
from gurobipy import Model, GRB

# Create a new model
m = Model("PlantOptimization")

# Create variables
tomato_vines = m.addVar(vtype=GRB.INTEGER, name="tomato_vines")
orange_trees = m.addVar(vtype=GRB.INTEGER, name="orange_trees")
chrysanthemums = m.addVar(vtype=GRB.INTEGER, name="chrysanthemums")
apple_trees = m.addVar(vtype=GRB.INTEGER, name="apple_trees")

# Set objective function
m.setObjective(8 * tomato_vines + 2 * orange_trees + 7 * chrysanthemums + 7 * apple_trees, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10 * orange_trees + 9 * chrysanthemums >= 14, "c1")
m.addConstr(3 * orange_trees + 4 * chrysanthemums + 8 * apple_trees >= 24, "c2")
m.addConstr(8 * tomato_vines + 4 * chrysanthemums + 8 * apple_trees >= 24, "c3")
m.addConstr(8 * tomato_vines + 3 * orange_trees + 8 * apple_trees >= 24, "c4")
m.addConstr(3 * orange_trees + 4 * chrysanthemums + 8 * apple_trees >= 30, "c5")
m.addConstr(8 * tomato_vines + 4 * chrysanthemums + 8 * apple_trees >= 30, "c6")
m.addConstr(8 * tomato_vines + 3 * orange_trees + 8 * apple_trees >= 30, "c7")
m.addConstr(3 * orange_trees + 4 * chrysanthemums + 8 * apple_trees >= 33, "c8")
m.addConstr(8 * tomato_vines + 4 * chrysanthemums + 8 * apple_trees >= 33, "c9")
m.addConstr(8 * tomato_vines + 3 * orange_trees + 8 * apple_trees >= 33, "c10")
m.addConstr(8 * tomato_vines + 9 * chrysanthemums <= 49, "c11")
m.addConstr(9 * chrysanthemums + 4 * apple_trees <= 48, "c12")
m.addConstr(10 * orange_trees + 4 * apple_trees <= 20, "c13")
m.addConstr(8 * tomato_vines + 10 * orange_trees <= 66, "c14")
m.addConstr(8 * tomato_vines + 4 * apple_trees <= 55, "c15")
m.addConstr(10 * orange_trees + 9 * chrysanthemums + 4 * apple_trees <= 45, "c16")
m.addConstr(8 * tomato_vines + 10 * orange_trees + 9 * chrysanthemums + 4 * apple_trees <= 27, "c18") # Combined c17 and c18
m.addConstr(3 * orange_trees + 4 * chrysanthemums <= 111, "c19")
m.addConstr(4 * chrysanthemums + 8 * apple_trees <= 49, "c20")
m.addConstr(8 * tomato_vines + 3 * orange_trees <= 64, "c21")
m.addConstr(3 * orange_trees + 8 * apple_trees <= 51, "c22")
m.addConstr(8 * tomato_vines + 4 * chrysanthemums <= 137, "c23")
m.addConstr(8 * tomato_vines + 3 * orange_trees + 4 * chrysanthemums <= 36, "c24")
m.addConstr(8 * tomato_vines + 4 * chrysanthemums + 8 * apple_trees <= 63, "c25")
m.addConstr(8 * tomato_vines + 3 * orange_trees + 4 * chrysanthemums + 8 * apple_trees <= 63, "c26")


# Resource constraints (given in the context)
m.addConstr(8 * tomato_vines + 10 * orange_trees + 9 * chrysanthemums + 4 * apple_trees <= 69, "growth_speed")
m.addConstr(8 * tomato_vines + 3 * orange_trees + 4 * chrysanthemums + 8 * apple_trees <= 140, "planting_space")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

