
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    vitamin_k = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_k")
    vitamin_a = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_a")

    # Set objective function
    m.setObjective(9 * vitamin_k + 2 * vitamin_a, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(2 * vitamin_k + 15 * vitamin_a >= 62, "cardiovascular_lower")
    m.addConstr(7 * vitamin_k + 11 * vitamin_a >= 74, "kidney_lower")
    m.addConstr(5 * vitamin_k + 8 * vitamin_a >= 11, "immune_lower")
    m.addConstr(2 * vitamin_k + 8 * vitamin_a >= 34, "cognitive_lower")
    m.addConstr(-4 * vitamin_k + 5 * vitamin_a >= 0, "vitamin_ratio")

    m.addConstr(2 * vitamin_k + 15 * vitamin_a <= 82, "cardiovascular_upper")
    m.addConstr(7 * vitamin_k + 11 * vitamin_a <= 111, "kidney_upper")
    m.addConstr(5 * vitamin_k + 8 * vitamin_a <= 49, "immune_upper")
    m.addConstr(2 * vitamin_k + 8 * vitamin_a <= 98, "cognitive_upper")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Optimal objective value: %g' % m.objVal)
        print('Vitamin K: %g' % vitamin_k.x)
        print('Vitamin A: %g' % vitamin_a.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
