
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Add variables
x0 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_K")
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_A")

# Set the objective function
m.setObjective(9*x0 + 2*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x0 + 15*x1 >= 62, name="cardiovascular_support_min")
m.addConstr(2*x0 + 15*x1 <= 82, name="cardiovascular_support_max")
m.addConstr(7*x0 + 11*x1 >= 74, name="kidney_support_min")
m.addConstr(7*x0 + 11*x1 <= 111, name="kidney_support_max")
m.addConstr(5*x0 + 8*x1 >= 11, name="immune_support_min")
m.addConstr(5*x0 + 8*x1 <= 49, name="immune_support_max")
m.addConstr(2*x0 + 8*x1 >= 34, name="cognitive_performance_min")
m.addConstr(2*x0 + 8*x1 <= 98, name="cognitive_performance_max")
m.addConstr(-4*x0 + 5*x1 >= 0, name="additional_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin K: {x0.x}")
    print(f"Milligrams of Vitamin A: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
