
import gurobipy as gp

# Create a new model
m = gp.Model("Vitamin_Optimization")

# Define variables
vitamin_K = m.addVar(name="vitamin_K", lb=0)  # Assuming non-negative
vitamin_A = m.addVar(name="vitamin_A", lb=0)  # Assuming non-negative

# Objective function
m.setObjective(9 * vitamin_K + 2 * vitamin_A, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(2 * vitamin_K + 15 * vitamin_A >= 62, name="cardiovascular_support_min")
m.addConstr(7 * vitamin_K + 11 * vitamin_A >= 74, name="kidney_support_min")
m.addConstr(5 * vitamin_K + 8 * vitamin_A >= 11, name="immune_support_min")
m.addConstr(2 * vitamin_K + 8 * vitamin_A >= 34, name="cognitive_performance_min")
m.addConstr(-4 * vitamin_K + 5 * vitamin_A >= 0, name="linear_constraint")

m.addConstr(2 * vitamin_K + 15 * vitamin_A <= 82, name="cardiovascular_support_max")
m.addConstr(7 * vitamin_K + 11 * vitamin_A <= 111, name="kidney_support_max")
m.addConstr(5 * vitamin_K + 8 * vitamin_A <= 49, name="immune_support_max")
m.addConstr(2 * vitamin_K + 8 * vitamin_A <= 98, name="cognitive_performance_max")

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Milligrams of Vitamin K: {vitamin_K.varValue}")
    print(f"Milligrams of Vitamin A: {vitamin_A.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
