
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
cheeseburgers = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cheeseburgers")
lemons = m.addVar(vtype=gp.GRB.INTEGER, name="lemons")
bacon = m.addVar(vtype=gp.GRB.INTEGER, name="bacon")
hotdogs = m.addVar(vtype=gp.GRB.INTEGER, name="hotdogs")

# Set objective function
m.setObjective(9.28 * cheeseburgers + 9.53 * lemons + 1.87 * bacon + 8.04 * hotdogs, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8 * cheeseburgers + 3 * hotdogs >= 6, "carbohydrate_constraint1")
m.addConstr(6 * lemons + 3 * hotdogs >= 10, "carbohydrate_constraint2")
m.addConstr(8 * cheeseburgers + 6 * lemons >= 15, "carbohydrate_constraint3")
m.addConstr(8 * cheeseburgers + 6 * lemons + 4 * bacon + 3 * hotdogs >= 15, "carbohydrate_constraint4")

m.addConstr(3 * lemons + 3 * hotdogs >= 11, "cost_constraint1")
m.addConstr(3 * lemons + 5 * bacon >= 4, "cost_constraint2")
m.addConstr(5 * bacon + 3 * hotdogs >= 13, "cost_constraint3")
m.addConstr(1 * cheeseburgers + 3 * hotdogs >= 7, "cost_constraint4")
m.addConstr(1 * cheeseburgers + 5 * bacon + 3 * hotdogs >= 13, "cost_constraint5")
m.addConstr(1 * cheeseburgers + 3 * lemons + 5 * bacon + 3 * hotdogs >= 13, "cost_constraint6")


m.addConstr(3 * lemons + 7 * hotdogs >= 9, "fat_constraint1")
m.addConstr(3 * bacon + 7 * hotdogs >= 11, "fat_constraint2")
m.addConstr(3 * cheeseburgers + 7 * hotdogs >= 5, "fat_constraint3")
m.addConstr(3 * cheeseburgers + 3 * bacon >= 12, "fat_constraint4")
m.addConstr(3 * cheeseburgers + 3 * bacon + 7 * hotdogs >= 9, "fat_constraint5")
m.addConstr(3 * lemons + 3 * bacon + 7 * hotdogs >= 9, "fat_constraint6")
m.addConstr(3 * cheeseburgers + 3 * bacon + 7 * hotdogs >= 12, "fat_constraint7")
m.addConstr(3 * lemons + 3 * bacon + 7 * hotdogs >= 12, "fat_constraint8")
m.addConstr(3 * cheeseburgers + 3 * lemons + 3 * bacon + 7 * hotdogs >= 12, "fat_constraint9")

m.addConstr(6 * bacon - 6 * hotdogs >= 0, "bacon_hotdog_constraint")

m.addConstr(8 * cheeseburgers + 6 * lemons <= 40, "carbohydrate_constraint5")
m.addConstr(6 * lemons + 4 * bacon <= 32, "carbohydrate_constraint6")
m.addConstr(8 * cheeseburgers + 4 * bacon <= 57, "carbohydrate_constraint7")
m.addConstr(8 * cheeseburgers + 3 * hotdogs <= 52, "carbohydrate_constraint8")
m.addConstr(6 * lemons + 3 * hotdogs <= 25, "carbohydrate_constraint9")
m.addConstr(8 * cheeseburgers + 6 * lemons + 4 * bacon <= 54, "carbohydrate_constraint10")
m.addConstr(8 * cheeseburgers + 4 * bacon + 3 * hotdogs <= 67, "carbohydrate_constraint11")
m.addConstr(8 * cheeseburgers + 6 * lemons + 3 * hotdogs <= 34, "carbohydrate_constraint12")

m.addConstr(1 * cheeseburgers + 5 * bacon + 3 * hotdogs <= 39, "cost_constraint7")

m.addConstr(3 * lemons + 7 * hotdogs <= 18, "fat_constraint10")
m.addConstr(3 * cheeseburgers + 3 * lemons + 7 * hotdogs <= 38, "fat_constraint11")
m.addConstr(3 * lemons + 3 * bacon + 7 * hotdogs <= 20, "fat_constraint12")
m.addConstr(3 * cheeseburgers + 3 * bacon + 7 * hotdogs <= 37, "fat_constraint13")


# Resource Constraints (given in the problem description)
m.addConstr(8 * cheeseburgers + 6 * lemons + 4 * bacon + 3 * hotdogs <= 70, "total_carbohydrates")
m.addConstr(1 * cheeseburgers + 3 * lemons + 5 * bacon + 3 * hotdogs <= 53, "total_cost")
m.addConstr(3 * cheeseburgers + 3 * lemons + 3 * bacon + 7 * hotdogs <= 58, "total_fat")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('\nCost: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

