
from gurobipy import Model, GRB

# Create a new model
model = Model("vitamin_optimization")

# Create variables
b3 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="B3")
b6 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="B6")
b9 = model.addVar(lb=0, vtype=GRB.INTEGER, name="B9")
b5 = model.addVar(lb=0, vtype=GRB.INTEGER, name="B5")

# Set objective function
obj = 3*b3**2 + 2*b3*b9 + 7*b3*b5 + b6**2 + 7*b6*b5 + b9**2 + 4*b9*b5 + 3*b5**2 + 3*b3 + 3*b6 + 7*b9 + 6*b5
model.setObjective(obj, GRB.MINIMIZE)

# Add constraints
model.addConstr(4*b6 + 19*b5 >= 19, "c1")
model.addConstr(4*b6**2 + 2*b9**2 >= 13, "c2")
model.addConstr(9*b3 + 4*b6 >= 11, "c3")
model.addConstr(9*b3 + 19*b5 >= 18, "c4")
model.addConstr(4*b6 + 2*b9 + 19*b5 >= 25, "c5")
model.addConstr(9*b3 + 2*b9 + 19*b5 >= 25, "c6")
model.addConstr(9*b3 + 4*b6 + 19*b5 >= 25, "c7")
model.addConstr(4*b6 + 2*b9 + 19*b5 >= 21, "c8")
model.addConstr(9*b3 + 2*b9 + 19*b5 >= 21, "c9")
model.addConstr(9*b3 + 4*b6 + 19*b5 >= 21, "c10")
model.addConstr(4*b6 + 2*b9 + 19*b5 >= 23, "c11")
model.addConstr(9*b3 + 2*b9 + 19*b5 >= 23, "c12")
model.addConstr(9*b3 + 4*b6 + 19*b5 >= 23, "c13")
model.addConstr(9*b3 + 4*b6 + 2*b9 + 19*b5 >= 23, "c14")
model.addConstr(9*b3**2 - 7*b5**2 >= 0, "c15")
model.addConstr(8*b3 - 8*b6 >= 0, "c16")
model.addConstr(9*b3 + 2*b9 <= 59, "c17")
model.addConstr(9*b3 + 4*b6 + 2*b9 + 19*b5 <= 118, "c18") # Immune support index upper bound


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('B3:', b3.x)
    print('B6:', b6.x)
    print('B9:', b9.x)
    print('B5:', b5.x)
elif model.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % model.status)
