
import gurobi as gp
from gurobi import GRB

# Create a new model
m = gp.Model("vitamin")

# Define the variables
x0 = m.addVar(lb=-gp.GRB.INF, ub=gp.GRB.INF, name="x0") # milligrams of vitamin B3
x1 = m.addVar(lb=-gp.GRB.INF, ub=gp.GRB.INF, name="x1") # milligrams of vitamin B6
x2 = m.addVar(lb=0, ub=gp.GRB.INF, integrality=1, name="x2") # milligrams of vitamin B9, integer
x3 = m.addVar(lb=0, ub=gp.GRB.INF, integrality=1, name="x3") # milligrams of vitamin B5, integer

# Objective function
m.setObjective(3*x0**2 + 2*x0*x2 + 7*x0*x3 + x1**2 + 7*x1*x3 + x2**2 + 4*x2*x3 + 3*x3**2 + 3*x0 + 3*x1 + 7*x2 + 6*x3, GRB.MINIMIZE)

# Constraints
m.addConstr(9 * x0 <= 118)
m.addConstr(4 * x1 <= 118)
m.addConstr(2 * x2 <= 118)
m.addConstr(19 * x3 <= 118)

m.addConstr(4 * x1 + 19 * x3 >= 19)
m.addConstr(x1**2 * 16 + x2**2 * 4 >= 13) 
m.addConstr(9 * x0 + 4 * x1 >= 11)
m.addConstr(9 * x0 + 19 * x3 >= 18)
m.addConstr(4 * x1 + 2 * x2 + 19 * x3 >= 25)
m.addConstr(9 * x0 + 2 * x2 + 19 * x3 >= 25)
m.addConstr(9 * x0 + 4 * x1 + 19 * x3 >= 25)
m.addConstr(4 * x1 + 2 * x2 + 19 * x3 >= 21)
m.addConstr(9 * x0 + 2 * x2 + 19 * x3 >= 21)
m.addConstr(9 * x0 + 4 * x1 + 19 * x3 >= 21)
m.addConstr(4 * x1 + 2 * x2 + 19 * x3 >= 23)
m.addConstr(9 * x0 + 2 * x2 + 19 * x3 >= 23)
m.addConstr(9 * x0 + 4 * x1 + 19 * x3 >= 23)
m.addConstr(9 * x0 + 4 * x1 + 2 * x2 + 19 * x3 >= 23)

m.addConstr(81 * x0**2 - 7 * x3**2 >= 0)
m.addConstr(8 * x0 - 8 * x1 >= 0)
m.addConstr(9 * x0 + 2 * x2 <= 59)

# Solve the model
m.optimize()

if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print("x0:", x0.varValue)
    print("x1:", x1.varValue)
    print("x2:", x2.varValue)
    print("x3:", x3.varValue)
    print("Objective:", m.objVal)
else:
    print("No optimal solution found.")
