
from gurobipy import Model, GRB

# Create a new model
model = Model("minimize_likelihood_to_quit")

# Create variables
jean_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="jean_hours")
george_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="george_hours")
bill_hours = model.addVar(lb=0, vtype=GRB.INTEGER, name="bill_hours")

# Set objective function
model.setObjective(7.52 * jean_hours + 9.79 * george_hours + 6.1 * bill_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(3 * jean_hours + 8 * bill_hours >= 14, "c1")
model.addConstr(2 * george_hours + 8 * bill_hours >= 19, "c2")
model.addConstr(3 * jean_hours + 2 * george_hours >= 13, "c3")
model.addConstr(3 * jean_hours + 2 * george_hours + 8 * bill_hours >= 22, "c4")
model.addConstr(9 * jean_hours - 3 * bill_hours >= 0, "c5")
model.addConstr(7 * jean_hours - 2 * george_hours >= 0, "c6")
model.addConstr(2 * george_hours + 8 * bill_hours <= 48, "c7")
model.addConstr(3 * jean_hours + 8 * bill_hours <= 38, "c8")


# Optimize model
model.optimize()

# Check for infeasibility
if model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal solution found:")
    print(f"Jean's hours: {jean_hours.x}")
    print(f"George's hours: {george_hours.x}")
    print(f"Bill's hours: {bill_hours.x}")
    print(f"Objective value: {model.objVal}")

