
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
jean = m.addVar(lb=0, name="jean")  # hours worked by Jean
george = m.addVar(lb=0, name="george")  # hours worked by George
bill = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="bill")  # hours worked by Bill

# Define the objective function
m.setObjective(7.52 * jean + 9.79 * george + 6.1 * bill, gp.GRB.MINIMIZE)

# Define the constraints
m.addConstr(jean >= 0, name="jean_non_negative")
m.addConstr(george >= 0, name="george_non_negative")
m.addConstr(bill >= 0, name="bill_non_negative")

# Likelihood to quit index constraints
m.addConstr(3 * jean + 8 * bill >= 14, name="likelihood_jean_bill")
m.addConstr(2 * george + 8 * bill >= 19, name="likelihood_george_bill")
m.addConstr(3 * jean + 2 * george >= 13, name="likelihood_jean_george")
m.addConstr(3 * jean + 2 * george + 8 * bill >= 22, name="likelihood_all")

# Additional constraints
m.addConstr(9 * jean - 3 * bill >= 0, name="jean_bill_constraint")
m.addConstr(7 * jean - 2 * george >= 0, name="jean_george_constraint")
m.addConstr(2 * george + 8 * bill <= 48, name="george_bill_upper_bound")
m.addConstr(3 * jean + 8 * bill <= 38, name="jean_bill_upper_bound")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Jean: {jean.varValue}")
    print(f"Hours worked by George: {george.varValue}")
    print(f"Hours worked by Bill: {bill.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
