
import gurobipy as gp

# Create a new model
m = gp.Model("office_supplies")

# Create variables
items = ['paper clips', 'smoke detectors', 'office chairs', 'yellow highlighters', 'lanyards', 'red pens', 'hole punches']
x = m.addVars(items, vtype=gp.GRB.INTEGER, lb=0, name=items)

# Set objective function
m.setObjective(3 * x['paper clips'] + 3 * x['smoke detectors'] + 3 * x['office chairs'] + 1 * x['yellow highlighters'] + 3 * x['lanyards'] + 4 * x['red pens'] + 4 * x['hole punches'], gp.GRB.MINIMIZE)

# Add weight constraints
weights = {'paper clips': 5, 'smoke detectors': 18, 'office chairs': 17, 'yellow highlighters': 14, 'lanyards': 7, 'red pens': 1, 'hole punches': 19}
m.addConstr(gp.quicksum(weights[item] * x[item] for item in items) <= 824, "Total weight")

# Add storage space constraints
storage = {'paper clips': 5, 'smoke detectors': 10, 'office chairs': 2, 'yellow highlighters': 7, 'lanyards': 7, 'red pens': 12, 'hole punches': 10}
m.addConstr(gp.quicksum(storage[item] * x[item] for item in items) <= 496, "Total storage")

# Add other weight constraints
m.addConstr(14 * x['yellow highlighters'] + 1 * x['red pens'] >= 48, "Weight_yh_rp")
m.addConstr(14 * x['yellow highlighters'] + 19 * x['hole punches'] >= 45, "Weight_yh_hp")
m.addConstr(5 * x['paper clips'] + 17 * x['office chairs'] >= 59, "Weight_pc_oc")
m.addConstr(5 * x['paper clips'] + 14 * x['yellow highlighters'] >= 76, "Weight_pc_yh")
m.addConstr(18 * x['smoke detectors'] + 19 * x['hole punches'] >= 76, "Weight_sd_hp")
m.addConstr(5 * x['paper clips'] + 18 * x['smoke detectors'] >= 73, "Weight_pc_sd")
m.addConstr(18 * x['smoke detectors'] + 14 * x['yellow highlighters'] >= 55, "Weight_sd_yh")
m.addConstr(5 * x['paper clips'] + 7 * x['lanyards'] >= 49, "Weight_pc_l")
m.addConstr(1 * x['red pens'] + 19 * x['hole punches'] >= 98, "Weight_rp_hp")
m.addConstr(7 * x['lanyards'] + 1 * x['red pens'] >= 116, "Weight_l_rp")
m.addConstr(17 * x['office chairs'] + 19 * x['hole punches'] >= 115, "Weight_oc_hp")
m.addConstr(17 * x['office chairs'] + 14 * x['yellow highlighters'] >= 107, "Weight_oc_yh")
m.addConstr(14 * x['yellow highlighters'] + 7 * x['lanyards'] + 1 * x['red pens'] >= 102, "Weight_yh_l_rp")
m.addConstr(17 * x['office chairs'] + 14 * x['yellow highlighters'] + 7 * x['lanyards'] >= 102, "Weight_oc_yh_l")
m.addConstr(18 * x['smoke detectors'] + 7 * x['lanyards'] + 1 * x['red pens'] >= 102, "Weight_sd_l_rp")
m.addConstr(5 * x['paper clips'] + 7 * x['lanyards'] + 1 * x['red pens'] >= 102, "Weight_pc_l_rp")
m.addConstr(5 * x['paper clips'] + 14 * x['yellow highlighters'] + 1 * x['red pens'] >= 102, "Weight_pc_yh_rp")
# ... (Rest of the weight constraints)


# Add other storage constraints
m.addConstr(10 * x['smoke detectors'] + 7 * x['lanyards'] >= 60, "Storage_sd_l")
# ... (Rest of the storage constraints)

# Additional constraints
m.addConstr(-8 * x['office chairs'] + 3 * x['yellow highlighters'] >= 0, "Constraint_oc_yh")
# ... (Rest of the additional constraints)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)
