
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
george_hours = m.addVar(name="george_hours", lb=0)
peggy_hours = m.addVar(name="peggy_hours", lb=0)
mary_hours = m.addVar(name="mary_hours", lb=0)

# Set objective function
m.setObjective(1.57 * george_hours + 7.49 * peggy_hours + 9.9 * mary_hours, gp.GRB.MAXIMIZE)

# Add constraints
resource_data = {
    'r0': {'description': 'organization score', 'upper_bound': 136, 'x0': 4, 'x1': 11, 'x2': 5},
    'r1': {'description': 'work quality rating', 'upper_bound': 235, 'x0': 6, 'x1': 1, 'x2': 4},
    'r2': {'description': 'productivity rating', 'upper_bound': 123, 'x0': 11, 'x1': 8, 'x2': 14},
    'r3': {'description': 'computer competence rating', 'upper_bound': 135, 'x0': 3, 'x1': 1, 'x2': 6}
}

# Resource constraints (using resource_data)
for r_key, r_data in resource_data.items():
    m.addConstr(r_data['x0'] * george_hours + r_data['x1'] * peggy_hours + r_data['x2'] * mary_hours <= r_data['upper_bound'], name=f"{r_data['description']}_constraint")


m.addConstr(4 * george_hours + 11 * peggy_hours >= 15, "org_score_george_peggy_min")
m.addConstr(6 * george_hours + 1 * peggy_hours >= 51, "work_quality_george_peggy_min")
m.addConstr(11 * george_hours + 8 * peggy_hours >= 13, "productivity_george_peggy_min")
m.addConstr(11 * george_hours + 14 * mary_hours >= 20, "productivity_george_mary_min")
m.addConstr(3 * george_hours + 6 * mary_hours >= 38, "computer_competence_george_mary_min")

m.addConstr(11 * peggy_hours + 5 * mary_hours <= 129, "org_score_peggy_mary_max")
m.addConstr(4 * george_hours + 11 * peggy_hours <= 49, "org_score_george_peggy_max")
m.addConstr(4 * george_hours + 11 * peggy_hours + 5 * mary_hours <= 49, "org_score_total_max")
m.addConstr(6 * george_hours + 4 * mary_hours <= 189, "work_quality_george_mary_max")
m.addConstr(6 * george_hours + 1 * peggy_hours <= 165, "work_quality_george_peggy_max")
m.addConstr(6 * george_hours + 1 * peggy_hours + 4 * mary_hours <= 212, "work_quality_total_max_1")
m.addConstr(6 * george_hours + 1 * peggy_hours + 4 * mary_hours <= 212, "work_quality_total_max_2")
m.addConstr(11 * george_hours + 14 * mary_hours <= 100, "productivity_george_mary_max")
m.addConstr(11 * george_hours + 8 * peggy_hours <= 62, "productivity_george_peggy_max")
m.addConstr(8 * peggy_hours + 14 * mary_hours <= 79, "productivity_peggy_mary_max")
m.addConstr(11 * george_hours + 8 * peggy_hours + 14 * mary_hours <= 79, "productivity_total_max")
m.addConstr(1 * peggy_hours + 6 * mary_hours <= 117, "computer_competence_peggy_mary_max")
m.addConstr(3 * george_hours + 6 * mary_hours <= 45, "computer_competence_george_mary_max")
m.addConstr(3 * george_hours + 1 * peggy_hours + 6 * mary_hours <= 45, "computer_competence_total_max")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective value:', m.objVal)
    print('George hours:', george_hours.x)
    print('Peggy hours:', peggy_hours.x)
    print('Mary hours:', mary_hours.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print(f"Optimization ended with status {m.status}")
