
from gurobipy import Model, GRB

# Create a new model
m = Model("food_optimization")

# Create variables
ravioli = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ravioli")
peanutbutter_sandwiches = m.addVar(lb=0, vtype=GRB.INTEGER, name="peanutbutter_sandwiches")
chicken_breasts = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chicken_breasts")

# Set objective function
m.setObjective(5 * ravioli + 6 * peanutbutter_sandwiches + 6 * chicken_breasts, GRB.MINIMIZE)

# Add constraints
m.addConstr(15 * ravioli + 15 * peanutbutter_sandwiches >= 13, "iron_constraint1")
m.addConstr(15 * ravioli + 8 * chicken_breasts >= 33, "iron_constraint2")
m.addConstr(15 * ravioli + 15 * peanutbutter_sandwiches + 8 * chicken_breasts >= 33, "iron_constraint3")
m.addConstr(17 * peanutbutter_sandwiches + 15 * chicken_breasts >= 30, "cost_constraint1")
m.addConstr(13 * ravioli + 17 * peanutbutter_sandwiches + 15 * chicken_breasts >= 68, "cost_constraint2")
m.addConstr(2 * ravioli - 5 * chicken_breasts >= 0, "constraint4")
m.addConstr(-1 * peanutbutter_sandwiches + 1 * chicken_breasts >= 0, "constraint5")
m.addConstr(15 * ravioli + 8 * chicken_breasts <= 38, "iron_constraint6")
m.addConstr(15 * ravioli + 15 * peanutbutter_sandwiches <= 68, "iron_constraint7")
m.addConstr(15 * ravioli <= 112, "iron_ravioli_ub")
m.addConstr(13 * ravioli <= 237, "cost_ravioli_ub")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('ravioli:', ravioli.x)
    print('peanutbutter_sandwiches:', peanutbutter_sandwiches.x)
    print('chicken_breasts:', chicken_breasts.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

