
import gurobipy as gp

# Define the model
model = gp.Model("Optimization Problem")

# Define the variables
ravioli = model.addVar(name="ravioli", lb=0)  # fractional
peanutbutter_sandwiches = model.addVar(name="peanutbutter_sandwiches", lb=0, integrality=gp.GRB.Integer)  # integer
chicken_breasts = model.addVar(name="chicken_breasts", lb=0)  # fractional

# Define the objective function
model.setObjective(5 * ravioli + 6 * peanutbutter_sandwiches + 6 * chicken_breasts, gp.GRB.MINIMIZE)

# Define the constraints
model.addConstr(15 * ravioli + 15 * peanutbutter_sandwiches >= 13, name="iron_ravioli_peanutbutter")
model.addConstr(15 * ravioli + 8 * chicken_breasts >= 33, name="iron_ravioli_chicken")
model.addConstr(15 * ravioli + 15 * peanutbutter_sandwiches + 8 * chicken_breasts >= 33, name="iron_all")
model.addConstr(15 * ravioli + 8 * chicken_breasts <= 38, name="iron_ravioli_chicken_max")
model.addConstr(15 * ravioli + 15 * peanutbutter_sandwiches <= 68, name="iron_ravioli_peanutbutter_max")

model.addConstr(13 * peanutbutter_sandwiches + 15 * chicken_breasts >= 30, name="cost_peanutbutter_chicken")
model.addConstr(13 * ravioli + 17 * peanutbutter_sandwiches + 15 * chicken_breasts >= 68, name="cost_all")

model.addConstr(2 * ravioli - 5 * chicken_breasts >= 0, name="ravioli_chicken_ratio")
model.addConstr(-peanutbutter_sandwiches + chicken_breasts >= 0, name="peanutbutter_chicken_ratio")

# Add bounds
model.addConstr(ravioli <= 112 / 15, name="ravioli_iron_bound")
model.addConstr(peanutbutter_sandwiches <= 237 / 17, name="peanutbutter_iron_bound")
model.addConstr(chicken_breasts <= 237 / 15, name="chicken_iron_bound")

model.addConstr(13 * ravioli + 17 * peanutbutter_sandwiches + 15 * chicken_breasts <= 237, name="cost_bound")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Ravioli: {ravioli.varValue}")
    print(f"Peanutbutter sandwiches: {peanutbutter_sandwiches.varValue}")
    print(f"Chicken breasts: {chicken_breasts.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
