
from gurobipy import Model, GRB

# Create a new model
model = Model("food_optimization")

# Create variables
potatoes = model.addVar(lb=0, name="potatoes")
sashimi = model.addVar(lb=0, name="sashimi")
ramen = model.addVar(lb=0, name="ramen")

# Set objective function
model.setObjective(6 * potatoes + 5 * sashimi + 2 * ramen, GRB.MAXIMIZE)

# Add constraints
model.addConstr(12.31 * sashimi + 5.36 * ramen >= 34, "c1")
model.addConstr(1.7 * potatoes + 5.36 * ramen >= 61, "c2")
model.addConstr(1.7 * potatoes + 12.31 * sashimi + 5.36 * ramen >= 67, "c3")
model.addConstr(10.23 * potatoes + 4.49 * sashimi >= 100, "c4")
model.addConstr(1.7 * potatoes + 5.36 * ramen <= 204, "c5")
model.addConstr(1.7 * potatoes + 12.31 * sashimi + 5.36 * ramen <= 204, "c6")
model.addConstr(10.23 * potatoes + 6.03 * ramen <= 163, "c7")
model.addConstr(10.23 * potatoes + 4.49 * sashimi + 6.03 * ramen <= 163, "c8")


# Optimize model
model.optimize()

# Check for infeasibility
if model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print results
    print("Optimal objective value:", model.objVal)
    print("Potatoes:", potatoes.x)
    print("Sashimi:", sashimi.x)
    print("Ramen:", ramen.x)

