
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the decision variables
potatoes = m.addVar(vtype=GRB.CONTINUOUS, name="potatoes")
sashimi = m.addVar(vtype=GRB.CONTINUOUS, name="sashimi")
bowls_of_instant_ramen = m.addVar(vtype=GRB.CONTINUOUS, name="bowls_of_instant_ramen")

# Objective function: Maximize 6*potatoes + 5*sashimi + 2*bowls_of_instant_ramen
m.setObjective(6 * potatoes + 5 * sashimi + 2 * bowls_of_instant_ramen, GRB.MAXIMIZE)

# Constraints:
# - Total tastiness from sashimi and bowls of instant ramen >= 34
m.addConstr(12.31 * sashimi + 5.36 * bowls_of_instant_ramen >= 34, name="tastiness_sashimi_ramen")

# - Total tastiness from potatoes and bowls of instant ramen >= 61
m.addConstr(1.7 * potatoes + 5.36 * bowls_of_instant_ramen >= 61, name="tastiness_potatoes_ramen")

# - Total tastiness from all three foods >= 67
m.addConstr(1.7 * potatoes + 12.31 * sashimi + 5.36 * bowls_of_instant_ramen >= 67, name="total_tastiness_min")

# - Iron from potatoes and sashimi >= 100 mg
m.addConstr(10.23 * potatoes + 4.49 * sashimi >= 100, name="iron_potatoes_sashimi_min")

# - Total tastiness from potatoes and bowls of instant ramen <= 204
m.addConstr(1.7 * potatoes + 5.36 * bowls_of_instant_ramen <= 204, name="tastiness_potatoes_ramen_max")

# - Total tastiness from all three foods <= 204
m.addConstr(1.7 * potatoes + 12.31 * sashimi + 5.36 * bowls_of_instant_ramen <= 204, name="total_tastiness_max")

# - Iron from potatoes and bowls of instant ramen <= 163 mg
m.addConstr(10.23 * potatoes + 6.03 * bowls_of_instant_ramen <= 163, name="iron_potatoes_ramen_max")

# - Total iron from all foods <= 163 mg
m.addConstr(10.23 * potatoes + 4.49 * sashimi + 6.03 * bowls_of_instant_ramen <= 163, name="total_iron_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Potatoes: {potatoes.x}")
    print(f"Sashimi: {sashimi.x}")
    print(f"Bowls of instant ramen: {bowls_of_instant_ramen.x}")
else:
    print("No optimal solution found")
