
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
potatoes = m.addVar(name="potatoes", lb=0)  # No lower bound specified, assuming 0
sashimi = m.addVar(name="sashimi", lb=0)    # No lower bound specified, assuming 0
bowls_of_instant_ramen = m.addVar(name="bowls_of_instant_ramen", lb=0)  # No lower bound specified, assuming 0

# Define the coefficients for the objective function
obj_func = 6 * potatoes + 5 * sashimi + 2 * bowls_of_instant_ramen

# Set the objective function
m.setObjective(obj_func, gp.GRB.MAXIMIZE)

# Define the constraints
r0_potatoes = 1.7 * potatoes
r0_sashimi = 12.31 * sashimi
r0_bowls_of_instant_ramen = 5.36 * bowls_of_instant_ramen

r1_potatoes = 10.23 * potatoes
r1_sashimi = 4.49 * sashimi
r1_bowls_of_instant_ramen = 6.03 * bowls_of_instant_ramen

# The total combined tastiness rating from sashimi plus bowls of instant ramen >= 34
m.addConstraint(r0_sashimi + r0_bowls_of_instant_ramen >= 34, name="tastiness_sashimi_ramen")

# The total combined tastiness rating from potatoes plus bowls of instant ramen >= 61
m.addConstraint(r0_potatoes + r0_bowls_of_instant_ramen >= 61, name="tastiness_potatoes_ramen")

# The total combined tastiness rating from potatoes, sashimi, and bowls of instant ramen >= 67
m.addConstraint(r0_potatoes + r0_sashimi + r0_bowls_of_instant_ramen >= 67, name="tastiness_total")

# The total iron from potatoes plus sashimi >= 100 milligrams
m.addConstraint(r1_potatoes + r1_sashimi >= 100, name="iron_potatoes_sashimi")

# The total combined tastiness rating from potatoes plus bowls of instant ramen <= 204
m.addConstraint(r0_potatoes + r0_bowls_of_instant_ramen <= 204, name="tastiness_potatoes_ramen_max")

# The total combined tastiness rating from potatoes, sashimi, and bowls of instant ramen <= 204
m.addConstraint(r0_potatoes + r0_sashimi + r0_bowls_of_instant_ramen <= 204, name="tastiness_total_max")

# The total iron from potatoes and bowls of instant ramen <= 163 milligrams
m.addConstraint(r1_potatoes + r1_bowls_of_instant_ramen <= 163, name="iron_potatoes_ramen")

# The total iron from potatoes, sashimi, and bowls of instant ramen <= 163 milligrams
m.addConstraint(r1_potatoes + r1_sashimi + r1_bowls_of_instant_ramen <= 163, name="iron_total")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Potatoes: {potatoes.varValue}")
    print(f"Sashimi: {sashimi.varValue}")
    print(f"Bowls of Instant Ramen: {bowls_of_instant_ramen.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("The model is infeasible.")
