
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
p = m.addVar(name="pansies", vtype=gp.GRB.INTEGER, lb=0)
z = m.addVar(name="zucchini_vines", vtype=gp.GRB.INTEGER, lb=0)
a = m.addVar(name="agave", vtype=gp.GRB.INTEGER, lb=0)
c = m.addVar(name="coleus", vtype=gp.GRB.INTEGER, lb=0)
r = m.addVar(name="carrots", vtype=gp.GRB.INTEGER, lb=0)
h = m.addVar(name="chives", vtype=gp.GRB.INTEGER, lb=0)
v = m.addVar(name="verbenas", vtype=gp.GRB.INTEGER, lb=0)

# Objective function
m.setObjective(6.08 * p**2 + 4.2 * p * z + 2.24 * p * a + 2.23 * p * c + 1.51 * p * r + 3.57 * p * h + 7.95 * p * v +
               8.13 * z**2 + 3.68 * z * a + 3.03 * z * c + 2.22 * z * r + 6.41 * z * h + 4.29 * z * v +
               5.2 * a**2 + 5.66 * a * c + 3.38 * a * r + 1.02 * a * h + 6.03 * c**2 + 9.7 * c * r + 9.0 * c * h +
               7.72 * c * v + 7.66 * r**2 + 6.78 * r * h + 9.05 * r * v + 9.27 * h**2 + 3.66 * h * v +
               9.74 * v**2 + 1.22 * p + 9.4 * z + 2.63 * a + 8.18 * c + 3.38 * r + 3.69 * h + 9.86 * v,
               gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(p == 10, name="pansies_yield")
m.addConstr(z == 10, name="zucchini_vines_yield")
m.addConstr(a == 3, name="agave_yield")
m.addConstr(c == 1, name="coleus_yield")
m.addConstr(r == 1, name="carrots_yield")
m.addConstr(h == 9, name="chives_yield")
m.addConstr(v == 11, name="verbenas_yield")

m.addConstr(5 * p + 4 * z + 9 * a + 5 * c + 11 * r + 6 * h + 10 * v <= 232, name="beauty_rating")
m.addConstr(6 * p + 12 * z + 7 * a + 3 * c + 5 * r + 14 * h + 2 * v <= 168, name="cost")

m.addConstr(a + h >= 29, name="agave_chives_yield")
m.addConstr(p + r >= 11, name="pansies_carrots_yield")
m.addConstr(z + v >= 24, name="zucchini_vines_verbenas_yield")
m.addConstr(p + v >= 22, name="pansies_verbenas_yield")
m.addConstr(p + z >= 35, name="pansies_zucchini_vines_yield")

try:
    m.optimize()
    if m.status == gp.GRB.Status.OPTIMAL:
        print("Objective: ", m.objVal)
        print("Pansies: ", p.varValue)
        print("Zucchini Vines: ", z.varValue)
        print("Agave: ", a.varValue)
        print("Coleus: ", c.varValue)
        print("Carrots: ", r.varValue)
        print("Chives: ", h.varValue)
        print("Verbenas: ", v.varValue)
    else:
        print("The model did not converge")
except gp.GRB.Error as e:
    print("Gurobi Error: ", e)
