
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamins = ['B6', 'B12', 'K', 'A', 'B7', 'B3']
vitamin_vars = m.addVars(vitamins, name="vitamin", lb=0.0)

# Set objective function
objective = 4.24 * vitamin_vars['B6'] + 5.15 * vitamin_vars['B12'] + 8.7 * vitamin_vars['K'] + 8.62 * vitamin_vars['A'] + 9.04 * vitamin_vars['B7'] + 7.04 * vitamin_vars['B3']
m.setObjective(objective, gp.GRB.MINIMIZE)

# Cognitive performance index coefficients
cpi = {'B6': 10, 'B12': 7, 'K': 6, 'A': 7, 'B7': 2, 'B3': 3}

# Add constraints
m.addConstr(cpi['B12'] * vitamin_vars['B12'] + cpi['B7'] * vitamin_vars['B7'] >= 9)
m.addConstr(cpi['B6'] * vitamin_vars['B6'] + cpi['B12'] * vitamin_vars['B12'] >= 14)
m.addConstr(cpi['A'] * vitamin_vars['A'] + cpi['B7'] * vitamin_vars['B7'] >= 9)
m.addConstr(cpi['A'] * vitamin_vars['A'] + cpi['B3'] * vitamin_vars['B3'] >= 18)
m.addConstr(cpi['B12'] * vitamin_vars['B12'] + cpi['B3'] * vitamin_vars['B3'] >= 9)
m.addConstr(cpi['B6'] * vitamin_vars['B6'] + cpi['K'] * vitamin_vars['K'] >= 9)
m.addConstr(cpi['B6'] * vitamin_vars['B6'] + cpi['A'] * vitamin_vars['A'] >= 17)
m.addConstr(cpi['B6'] * vitamin_vars['B6'] + cpi['B12'] * vitamin_vars['B12'] + cpi['B3'] * vitamin_vars['B3'] >= 19)
m.addConstr(cpi['B6'] * vitamin_vars['B6'] + cpi['K'] * vitamin_vars['K'] + cpi['A'] * vitamin_vars['A'] >= 19)
m.addConstr(cpi['B12'] * vitamin_vars['B12'] + cpi['A'] * vitamin_vars['A'] + cpi['B7'] * vitamin_vars['B7'] >= 19)
m.addConstr(cpi['B12'] * vitamin_vars['B12'] + cpi['K'] * vitamin_vars['K'] + cpi['A'] * vitamin_vars['A'] >= 19)
m.addConstr(cpi['B6'] * vitamin_vars['B6'] + cpi['A'] * vitamin_vars['A'] + cpi['B3'] * vitamin_vars['B3'] >= 19)
m.addConstr(cpi['K'] * vitamin_vars['K'] + cpi['B7'] * vitamin_vars['B7'] + cpi['B3'] * vitamin_vars['B3'] >= 19)
m.addConstr(cpi['B6'] * vitamin_vars['B6'] + cpi['B7'] * vitamin_vars['B7'] + cpi['B3'] * vitamin_vars['B3'] >= 19)

# ... (rest of the constraints, similarly structured)

m.addConstr(4 * vitamin_vars['B12'] - 5 * vitamin_vars['B7'] >= 0)
m.addConstr(2 * vitamin_vars['B6'] - 7 * vitamin_vars['A'] >= 0)
m.addConstr(-6 * vitamin_vars['K'] + 9 * vitamin_vars['B7'] >= 0)


# ... (rest of the constraints, similarly structured)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective:', m.objVal)
    for v in vitamins:
        print(f'Vitamin {v}: {vitamin_vars[v].x}')
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status:', m.status)

