
import gurobi as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Define variables
x0 = m.addVar(lb=0, name="vitamin_B6", vtype=gp.GRB.CONTINUOUS)
x1 = m.addVar(lb=0, name="vitamin_B12", vtype=gp.GRB.CONTINUOUS)
x2 = m.addVar(lb=0, name="vitamin_K", vtype=gp.GRB.CONTINUOUS)
x3 = m.addVar(lb=0, name="vitamin_A", vtype=gp.GRB.CONTINUOUS)
x4 = m.addVar(lb=0, name="vitamin_B7", vtype=gp.GRB.CONTINUOUS)
x5 = m.addVar(lb=0, name="vitamin_B3", vtype=gp.GRB.CONTINUOUS)

# Objective function
m.setObjective(4.24*x0 + 5.15*x1 + 8.7*x2 + 8.62*x3 + 9.04*x4 + 7.04*x5, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(7*x1 + 2*x4 >= 9, name="c1")
m.addConstr(10*x0 + 7*x1 >= 14, name="c2")
m.addConstr(7*x3 + 2*x4 >= 9, name="c3")
m.addConstr(7*x3 + 3*x5 >= 18, name="c4")
m.addConstr(7*x1 + 3*x5 >= 9, name="c5")
m.addConstr(10*x0 + 6*x2 >= 9, name="c6")
m.addConstr(10*x0 + 7*x3 >= 17, name="c7")
m.addConstr(10*x0 + 7*x1 + 3*x5 >= 19, name="c8")
m.addConstr(10*x0 + 6*x2 + 7*x3 >= 19, name="c9")
m.addConstr(7*x1 + 7*x3 + 2*x4 >= 19, name="c10")
m.addConstr(6*x2 + 7*x3 + 7*x1 >= 19, name="c11")
m.addConstr(10*x0 + 7*x3 + 3*x5 >= 19, name="c12")
m.addConstr(6*x2 + 2*x4 + 3*x5 >= 19, name="c13")
m.addConstr(10*x0 + 2*x4 + 3*x5 >= 19, name="c14")
m.addConstr(10*x0 + 7*x1 + 3*x5 >= 15, name="c15")
m.addConstr(10*x0 + 6*x2 + 7*x3 >= 15, name="c16")
m.addConstr(7*x1 + 7*x3 + 2*x4 >= 15, name="c17")
m.addConstr(6*x2 + 7*x3 + 7*x1 >= 15, name="c18")
m.addConstr(10*x0 + 7*x3 + 3*x5 >= 15, name="c19")
m.addConstr(6*x2 + 2*x4 + 3*x5 >= 15, name="c20")
m.addConstr(10*x0 + 2*x4 + 3*x5 >= 15, name="c21")
m.addConstr(10*x0 + 7*x1 + 3*x5 >= 23, name="c22")
m.addConstr(10*x0 + 6*x2 + 7*x3 >= 23, name="c23")
m.addConstr(7*x1 + 7*x3 + 2*x4 >= 23, name="c24")
m.addConstr(6*x2 + 7*x3 + 7*x1 >= 23, name="c25")
m.addConstr(10*x0 + 7*x3 + 3*x5 >= 23, name="c26")
m.addConstr(6*x2 + 2*x4 + 3*x5 >= 23, name="c27")
m.addConstr(10*x0 + 2*x4 + 3*x5 >= 23, name="c28")
m.addConstr(4*x1 - 5*x4 >= 0, name="c29")
m.addConstr(2*x0 - 7*x3 >= 0, name="c30")
m.addConstr(-6*x2 + 9*x4 >= 0, name="c31")
m.addConstr(10*x0 + 7*x1 <= 123, name="c32")
m.addConstr(10*x0 + 2*x4 <= 125, name="c33")
m.addConstr(6*x2 + 7*x3 <= 49, name="c34")
m.addConstr(7*x1 + 6*x2 <= 47, name="c35")
m.addConstr(7*x1 + 2*x4 <= 77, name="c36")
m.addConstr(10*x0 + 6*x2 <= 25, name="c37")
m.addConstr(6*x2 + 2*x4 <= 86, name="c38")
m.addConstr(7*x1 + 7*x3 <= 86, name="c39")
m.addConstr(10*x0 + 7*x3 <= 78, name="c40")
m.addConstr(7*x1 + 3*x5 <= 39, name="c41")
m.addConstr(10*x0 + 6*x2 + 3*x5 <= 60, name="c42")
m.addConstr(10*x0 + 7*x3 + 3*x5 <= 133, name="c43")
m.addConstr(7*x3 + 2*x4 + 3*x5 <= 123, name="c44")
m.addConstr(10*x0 + 7*x1 + 7*x3 <= 123, name="c45")
m.addConstr(7*x1 + 7*x3 + 2*x4 <= 71, name="c46")
m.addConstr(7*x1 + 2*x4 + 3*x5 <= 130, name="c47")
m.addConstr(6*x2 + 2*x4 + 3*x5 <= 48, name="c48")
m.addConstr(6*x2 + 7*x3 + 2*x4 <= 76, name="c49")
m.addConstr(10*x0 + 6*x2 + 7*x3 <= 131, name="c50")
m.addConstr(10*x0 + 2*x4 + 3*x5 <= 102, name="c51")
m.addConstr(6*x2 + 2*x4 <= 53, name="c52")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Vitamin B6: {x0.varValue}")
    print(f"Vitamin B12: {x1.varValue}")
    print(f"Vitamin K: {x2.varValue}")
    print(f"Vitamin A: {x3.varValue}")
    print(f"Vitamin B7: {x4.varValue}")
    print(f"Vitamin B3: {x5.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
