
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
strips_of_bacon = m.addVar(name="strips_of_bacon", lowBound=0)
bowls_of_cereal = m.addVar(name="bowls_of_cereal", lowBound=0, integrality=gp.GRB.INTEGER)
bananas = m.addVar(name="bananas", lowBound=0)
oranges = m.addVar(name="oranges", lowBound=0, integrality=gp.GRB.INTEGER)
black_beans = m.addVar(name="black_beans", lowBound=0)
knishes = m.addVar(name="knishes", lowBound=0)

# Define the objective function
m.setObjective(5 * strips_of_bacon + 7 * bowls_of_cereal + 9 * bananas + 4 * oranges + 4 * black_beans + 6 * knishes, gp.GRB.MAXIMIZE)

# Define the constraints
# Sourness index constraints
m.addConstr(17 * strips_of_bacon + 16 * bowls_of_cereal + 21 * bananas + 5 * oranges + 10 * black_beans + 8 * knishes <= 270, name="sourness_index")
# Milligrams of iron constraints
m.addConstr(11 * strips_of_bacon + 13 * bowls_of_cereal + 22 * bananas + 9 * oranges + 15 * black_beans + 8 * knishes <= 242, name="milligrams_of_iron")

# Additional constraints
m.addConstr(5 * oranges + 10 * black_beans >= 33, name="oranges_black_beans_sourness")
m.addConstr(5 * oranges + 8 * knishes >= 20, name="oranges_knishes_sourness")
m.addConstr(16 * bowls_of_cereal + 10 * black_beans >= 43, name="bowls_of_cereal_black_beans_sourness")
m.addConstr(21 * bananas + 8 * knishes >= 45, name="bananas_knishes_sourness")
m.addConstr(17 * strips_of_bacon + 5 * oranges >= 40, name="strips_of_bacon_oranges_sourness")
m.addConstr(10 * black_beans + 8 * knishes >= 38, name="black_beans_knishes_sourness")
m.addConstr(17 * strips_of_bacon + 16 * bowls_of_cereal + 5 * oranges >= 37, name="strips_of_bacon_bowls_of_cereal_oranges_sourness")
m.addConstr(5 * oranges + 10 * black_beans + 8 * knishes >= 37, name="oranges_black_beans_knishes_sourness")
m.addConstr(16 * bowls_of_cereal + 5 * oranges + 8 * knishes >= 37, name="bowls_of_cereal_oranges_knishes_sourness")
m.addConstr(17 * strips_of_bacon + 10 * black_beans + 8 * knishes >= 37, name="strips_of_bacon_black_beans_knishes_sourness")
m.addConstr(17 * strips_of_bacon + 16 * bowls_of_cereal + 5 * oranges >= 45, name="strips_of_bacon_bowls_of_cereal_oranges_sourness_2")
m.addConstr(5 * oranges + 10 * black_beans + 8 * knishes >= 45, name="oranges_black_beans_knishes_sourness_2")
m.addConstr(16 * bowls_of_cereal + 5 * oranges + 8 * knishes >= 45, name="bowls_of_cereal_oranges_knishes_sourness_2")
m.addConstr(17 * strips_of_bacon + 10 * black_beans + 8 * knishes >= 45, name="strips_of_bacon_black_beans_knishes_sourness_2")

# Iron constraints
m.addConstr(9 * oranges + 15 * black_beans >= 35, name="oranges_black_beans_iron")
m.addConstr(15 * black_beans + 8 * knishes >= 15, name="black_beans_knishes_iron")
m.addConstr(13 * bowls_of_cereal + 22 * bananas >= 37, name="bowls_of_cereal_bananas_iron")
m.addConstr(9 * oranges + 15 * black_beans >= 27, name="oranges_black_beans_iron_2")
m.addConstr(11 * strips_of_bacon + 8 * knishes >= 28, name="strips_of_bacon_knishes_iron")
m.addConstr(11 * strips_of_bacon + 9 * oranges >= 25, name="strips_of_bacon_oranges_iron")
m.addConstr(11 * strips_of_bacon + 15 * black_beans >= 33, name="strips_of_bacon_black_beans_iron")
m.addConstr(9 * oranges + 8 * knishes >= 18, name="oranges_knishes_iron")

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Strips of bacon: ", strips_of_bacon.varValue)
    print("Bowls of cereal: ", bowls_of_cereal.varValue)
    print("Bananas: ", bananas.varValue)
    print("Oranges: ", oranges.varValue)
    print("Black beans: ", black_beans.varValue)
    print("Knishes: ", knishes.varValue)
else:
    print("No optimal solution found")
