
from gurobipy import Model, GRB

# Create a new model
model = Model("Work Hours Optimization")

# Create variables
john_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="John_Hours")
hank_hours = model.addVar(lb=0, vtype=GRB.INTEGER, name="Hank_Hours")
bobby_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Bobby_Hours")
dale_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Dale_Hours")

# Set objective function
model.setObjective(1 * john_hours + 7 * hank_hours + 1 * bobby_hours + 1 * dale_hours, GRB.MAXIMIZE)

# Add constraints
model.addConstr(8 * john_hours + 10 * dale_hours >= 37, "c1")
model.addConstr(6 * hank_hours + 11 * bobby_hours >= 35, "c2")
model.addConstr(8 * john_hours + 10 * dale_hours <= 158, "c3")
model.addConstr(8 * john_hours + 6 * hank_hours <= 109, "c4")
model.addConstr(6 * hank_hours + 11 * bobby_hours <= 193, "c5")
model.addConstr(6 * hank_hours + 10 * dale_hours <= 103, "c6")
model.addConstr(8 * john_hours + 6 * hank_hours + 11 * bobby_hours <= 124, "c7")
model.addConstr(8 * john_hours + 6 * hank_hours + 11 * bobby_hours + 10 * dale_hours <= 124, "c8")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('John Hours: %g' % john_hours.x)
    print('Hank Hours: %g' % hank_hours.x)
    print('Bobby Hours: %g' % bobby_hours.x)
    print('Dale Hours: %g' % dale_hours.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

