
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="hours_worked_by_John")
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="hours_worked_by_Hank")
x2 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="hours_worked_by_Bobby")
x3 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="hours_worked_by_Dale")

# Define objective function
m.setObjective(1*x0 + 7*x1 + 1*x2 + 1*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(8*x0 + 10*x3 >= 37, name="constraint_1")
m.addConstr(6*x1 + 11*x2 >= 35, name="constraint_2")
m.addConstr(8*x0 + 10*x3 <= 158, name="constraint_3")
m.addConstr(8*x0 + 6*x1 <= 109, name="constraint_4")
m.addConstr(6*x1 + 11*x2 <= 193, name="constraint_5")
m.addConstr(6*x1 + 10*x3 <= 103, name="constraint_6")
m.addConstr(8*x0 + 6*x1 + 11*x2 <= 124, name="constraint_7")
m.addConstr(8*x0 + 6*x1 + 11*x2 + 10*x3 <= 223, name="upper_bound_constraint")

# Optimize the model
m.optimize()

# Print results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print(f"Objective: {m.objVal}")
