
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
hours_worked_by_John = m.addVar(lb=0, name="hours_worked_by_John")
hours_worked_by_Hank = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="hours_worked_by_Hank")
hours_worked_by_Bobby = m.addVar(lb=0, name="hours_worked_by_Bobby")
hours_worked_by_Dale = m.addVar(lb=0, name="hours_worked_by_Dale")

# Objective function
m.setObjective(1 * hours_worked_by_John + 7 * hours_worked_by_Hank + 1 * hours_worked_by_Bobby + 1 * hours_worked_by_Dale, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(8 * hours_worked_by_John + 10 * hours_worked_by_Dale >= 37, name="constraint_1")
m.addConstr(6 * hours_worked_by_Hank + 11 * hours_worked_by_Bobby >= 35, name="constraint_2")
m.addConstr(8 * hours_worked_by_John + 10 * hours_worked_by_Dale <= 158, name="constraint_3")
m.addConstr(8 * hours_worked_by_John + 6 * hours_worked_by_Hank <= 109, name="constraint_4")
m.addConstr(6 * hours_worked_by_Hank + 11 * hours_worked_by_Bobby <= 193, name="constraint_5")
m.addConstr(6 * hours_worked_by_Hank + 10 * hours_worked_by_Dale <= 103, name="constraint_6")
m.addConstr(8 * hours_worked_by_John + 6 * hours_worked_by_Hank + 11 * hours_worked_by_Bobby <= 124, name="constraint_7")
m.addConstr(8 * hours_worked_by_John + 6 * hours_worked_by_Hank + 11 * hours_worked_by_Bobby + 10 * hours_worked_by_Dale <= 124, name="constraint_8")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Hours worked by John: {hours_worked_by_John.varValue}")
    print(f"Hours worked by Hank: {hours_worked_by_Hank.varValue}")
    print(f"Hours worked by Bobby: {hours_worked_by_Bobby.varValue}")
    print(f"Hours worked by Dale: {hours_worked_by_Dale.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("The model is infeasible or unbounded.")
