
from gurobipy import Model, GRB

# Create a new model
model = Model("Optimization Problem")

# Create variables
black_beans = model.addVar(vtype=GRB.INTEGER, name="black_beans")
strawberries = model.addVar(vtype=GRB.INTEGER, name="strawberries")
blueberry_pies = model.addVar(vtype=GRB.INTEGER, name="blueberry_pies")
bananas = model.addVar(vtype=GRB.INTEGER, name="bananas")

# Set objective function
model.setObjective(3 * black_beans + 3 * strawberries + 4 * blueberry_pies + 1 * bananas, GRB.MAXIMIZE)

# Add constraints
model.addConstr(2 * black_beans + 12 * strawberries + 8 * blueberry_pies + 4 * bananas <= 610, "Dollar Cost")  # r0
model.addConstr(20 * black_beans + 1 * strawberries + 22 * blueberry_pies + 6 * bananas <= 645, "Carbohydrates")  # r1
model.addConstr(23 * black_beans + 6 * strawberries + 19 * blueberry_pies + 18 * bananas <= 299, "Sourness")  # r2

model.addConstr(8 * blueberry_pies + 4 * bananas >= 53, "Blueberry Pies and Bananas Cost")
model.addConstr(12 * strawberries + 8 * blueberry_pies >= 143, "Strawberries and Blueberry Pies Cost")
model.addConstr(2 * black_beans + 12 * strawberries >= 73, "Black Beans and Strawberries Cost")
model.addConstr(2 * black_beans + 8 * blueberry_pies >= 109, "Black Beans and Blueberry Pies Cost")
model.addConstr(2 * black_beans + 12 * strawberries + 4 * bananas >= 129, "Black Beans, Strawberries, and Bananas Cost")

model.addConstr(1 * strawberries + 22 * blueberry_pies + 6 * bananas >= 146, "Carbohydrates from Strawberries, Blueberry Pies, and Bananas")
model.addConstr(20 * black_beans + 1 * strawberries + 6 * bananas >= 146, "Carbohydrates from Black Beans, Strawberries, and Bananas")
model.addConstr(20 * black_beans + 22 * blueberry_pies + 6 * bananas >= 146, "Carbohydrates from Black Beans, Blueberry Pies, and Bananas")
model.addConstr(20 * black_beans + 1 * strawberries + 22 * blueberry_pies >= 146, "Carbohydrates from Black Beans, Strawberries, and Blueberry Pies")
model.addConstr(1 * strawberries + 22 * blueberry_pies + 6 * bananas >= 84, "Carbohydrates2 from Strawberries, Blueberry Pies, and Bananas")
model.addConstr(20 * black_beans + 1 * strawberries + 6 * bananas >= 84, "Carbohydrates2 from Black Beans, Strawberries, and Bananas")
model.addConstr(20 * black_beans + 22 * blueberry_pies + 6 * bananas >= 84, "Carbohydrates2 from Black Beans, Blueberry Pies, and Bananas")
model.addConstr(20 * black_beans + 1 * strawberries + 22 * blueberry_pies >= 84, "Carbohydrates2 from Black Beans, Strawberries, and Blueberry Pies")
model.addConstr(1 * strawberries + 22 * blueberry_pies + 6 * bananas >= 113, "Carbohydrates3 from Strawberries, Blueberry Pies, and Bananas")
model.addConstr(20 * black_beans + 1 * strawberries + 6 * bananas >= 113, "Carbohydrates3 from Black Beans, Strawberries, and Bananas")
model.addConstr(20 * black_beans + 22 * blueberry_pies + 6 * bananas >= 113, "Carbohydrates3 from Black Beans, Blueberry Pies, and Bananas")
model.addConstr(20 * black_beans + 1 * strawberries + 22 * blueberry_pies >= 113, "Carbohydrates3 from Black Beans, Strawberries, and Blueberry Pies")
model.addConstr(1 * strawberries + 22 * blueberry_pies + 6 * bananas >= 89, "Carbohydrates4 from Strawberries, Blueberry Pies, and Bananas")
model.addConstr(20 * black_beans + 1 * strawberries + 6 * bananas >= 89, "Carbohydrates4 from Black Beans, Strawberries, and Bananas")
model.addConstr(20 * black_beans + 22 * blueberry_pies + 6 * bananas >= 89, "Carbohydrates4 from Black Beans, Blueberry Pies, and Bananas")
model.addConstr(20 * black_beans + 1 * strawberries + 22 * blueberry_pies >= 89, "Carbohydrates4 from Black Beans, Strawberries, and Blueberry Pies")


model.addConstr(23 * black_beans + 6 * strawberries + 18 * bananas >= 38, "Sourness from Black Beans, Strawberries, and Bananas")
model.addConstr(-5 * strawberries + 1 * blueberry_pies + 1 * bananas >= 0, "Custom Constraint")

model.addConstr(2 * black_beans + 4 * bananas <= 440, "Black Beans and Bananas Cost Upper Bound")
model.addConstr(2 * black_beans + 8 * blueberry_pies <= 172, "Black Beans and Blueberry Pies Cost Upper Bound")
model.addConstr(2 * black_beans + 12 * strawberries <= 291, "Black Beans and Strawberries Cost Upper Bound")
model.addConstr(12 * strawberries + 8 * blueberry_pies <= 193, "Strawberries and Blueberry Pies Cost Upper Bound")
model.addConstr(2 * black_beans + 12 * strawberries + 8 * blueberry_pies + 4 * bananas <= 193, "Total Cost Upper Bound")

model.addConstr(1 * strawberries + 22 * blueberry_pies <= 574, "Strawberries and Blueberry Pies Carbohydrates Upper Bound")
model.addConstr(20 * black_beans + 22 * blueberry_pies <= 204, "Black Beans and Blueberry Pies Carbohydrates Upper Bound")
model.addConstr(22 * blueberry_pies + 6 * bananas <= 336, "Blueberry Pies and Bananas Carbohydrates Upper Bound")
model.addConstr(20 * black_beans + 1 * strawberries <= 217, "Black Beans and Strawberries Carbohydrates Upper Bound")
model.addConstr(20 * black_beans + 6 * bananas <= 535, "Black Beans and Bananas Carbohydrates Upper Bound")
model.addConstr(20 * black_beans + 22 * blueberry_pies + 6 * bananas <= 168, "Black Beans, Blueberry Pies, and Bananas Carbohydrates Upper Bound")
model.addConstr(20 * black_beans + 1 * strawberries + 6 * bananas <= 523, "Black Beans, Strawberries, and Bananas Carbohydrates Upper Bound")
model.addConstr(20 * black_beans + 1 * strawberries + 22 * blueberry_pies <= 611, "Black Beans, Strawberries, and Blueberry Pies Carbohydrates Upper Bound")
model.addConstr(20 * black_beans + 1 * strawberries + 22 * blueberry_pies + 6 * bananas <= 611, "Total Carbohydrates Upper Bound")

model.addConstr(23 * black_beans + 6 * strawberries <= 109, "Black Beans and Strawberries Sourness Upper Bound")
model.addConstr(19 * blueberry_pies + 18 * bananas <= 80, "Blueberry Pies and Bananas Sourness Upper Bound")
model.addConstr(23 * black_beans + 6 * strawberries + 19 * blueberry_pies + 18 * bananas <= 80, "Total Sourness Upper Bound")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
else:
    print("Infeasible")
