
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x0 = model.addVar(name="black_beans", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="strawberries", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="blueberry_pies", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="bananas", vtype=gurobi.GRB.INTEGER)
    
    # Objective function: Maximize 3x0 + 3x1 + 4x2 + x3
    model.setObjective(3*x0 + 3*x1 + 4*x2 + x3, gurobi.GRB.MAXIMIZE)
    
    # Constraints
    model.addConstr(2*x0 + 12*x1 + 8*x2 + 4*x3 <= 610)
    model.addConstr(20*x0 + x1 + 22*x2 + 6*x3 <= 645)
    model.addConstr(23*x0 + 6*x1 + 19*x2 + 18*x3 <= 299)
    model.addConstr(8*x2 + 4*x3 >= 53)
    model.addConstr(12*x1 + 8*x2 >= 143)
    model.addConstr(2*x0 + 12*x1 >= 73)
    model.addConstr(2*x0 + 8*x2 >= 109)
    model.addConstr(2*x0 + 12*x1 + 4*x3 >= 129)
    model.addConstr(20*x0 + x1 + 6*x3 >= 146)
    model.addConstr(20*x0 + 22*x2 + 6*x3 >= 146)
    model.addConstr(x1 + 22*x2 + 6*x3 >= 146)
    model.addConstr(x1 + 22*x2 + x3 >= 84)
    model.addConstr(20*x0 + x1 + x3 >= 84)
    model.addConstr(20*x0 + 22*x2 + x3 >= 84)
    model.addConstr(x1 + 22*x2 + 6*x3 >= 113)
    model.addConstr(20*x0 + x1 + 6*x3 >= 113)
    model.addConstr(20*x0 + 22*x2 + 6*x3 >= 113)
    model.addConstr(23*x0 + 6*x1 + 18*x3 >= 38)
    model.addConstr(-5*x1 + x2 + x3 >= 0)
    model.addConstr(2*x0 + 4*x3 <= 440)
    model.addConstr(2*x0 + 8*x2 <= 172)
    model.addConstr(2*x0 + 12*x1 <= 291)
    model.addConstr(12*x1 + 8*x2 <= 193)
    model.addConstr(2*x0 + 12*x1 + 8*x2 + 4*x3 <= 193)
    model.addConstr(x1 + 22*x2 <= 574)
    model.addConstr(20*x0 + 22*x2 <= 204)
    model.addConstr(22*x2 + 6*x3 <= 336)
    model.addConstr(20*x0 + x1 <= 217)
    model.addConstr(20*x0 + 6*x3 <= 535)
    model.addConstr(20*x0 + 22*x2 + 6*x3 <= 168)
    model.addConstr(20*x0 + x1 + 6*x3 <= 523)
    model.addConstr(20*x0 + x1 + 22*x2 <= 611)
    model.addConstr(23*x0 + 6*x1 <= 109)
    model.addConstr(19*x2 + 18*x3 <= 80)
    model.addConstr(23*x0 + 6*x1 + 19*x2 + 18*x3 <= 80)
    
    # Solve the model
    model.optimize()
    
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Black beans: ", x0.varValue)
        print("Strawberries: ", x1.varValue)
        print("Blueberry pies: ", x2.varValue)
        print("Bananas: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
