
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
b12 = m.addVar(lb=0, name="B12")
b5 = m.addVar(lb=0, name="B5")
iron = m.addVar(lb=0, name="Iron")

# Set objective function
m.setObjective(5 * b12 + 9 * b5 + 2 * iron, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(12 * b12 + 9 * b5 + 8 * iron >= 23, "c1")  # Total energy stability index minimum
m.addConstr(6 * b12 + 20 * b5 + 11 * iron <= 98, "c2") # Total muscle growth index maximum
m.addConstr(9 * b5 + 8 * iron >= 8, "c3")  # Combined energy stability index for B5 and Iron minimum
m.addConstr(6 * b12 + 11 * iron <= 98, "c4") # Combined muscle growth index for B12 and Iron maximum
m.addConstr(9 * b5 + 8 * iron <= 66, "c5")  # Combined energy stability index for B5 and Iron maximum
m.addConstr(12 * b12 + 9 * b5 + 8 * iron <= 66, "c6") # Total energy stability index maximum
m.addConstr(13 * b5 + 8 * iron <= 106, "c7") # Combined cognitive performance index for B5 and Iron maximum
m.addConstr(7 * b12 + 13 * b5 <= 67, "c8")  # Combined cognitive performance index for B12 and B5 maximum
m.addConstr(7 * b12 + 13 * b5 + 8 * iron <= 67, "c9") # Total cognitive performance index maximum


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('B12: %g' % b12.x)
    print('B5: %g' % b5.x)
    print('Iron: %g' % iron.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
