
import gurobi

def optimize_vitamins():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    vitamin_B12 = model.addVar(lb=-gurobi.GRB.INFINITY, name="vitamin_B12")
    vitamin_B5 = model.addVar(lb=-gurobi.GRB.INFINITY, name="vitamin_B5")
    iron = model.addVar(lb=-gurobi.GRB.INFINITY, name="iron")

    # Objective function
    model.setObjective(5 * vitamin_B12 + 9 * vitamin_B5 + 2 * iron, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(6 * vitamin_B12 + 20 * vitamin_B5 + 11 * iron <= 98, name="muscle_growth_index")
    model.addConstr(9 * vitamin_B5 + 8 * iron >= 8, name="energy_stability_index_B5_iron")
    model.addConstr(12 * vitamin_B12 + 9 * vitamin_B5 + 8 * iron >= 23, name="energy_stability_index_total")
    model.addConstr(9 * vitamin_B5 + 8 * iron <= 66, name="energy_stability_index_B5_iron_max")
    model.addConstr(12 * vitamin_B12 + 9 * vitamin_B5 + 8 * iron <= 66, name="energy_stability_index_total_max")
    model.addConstr(13 * vitamin_B5 + 8 * iron <= 106, name="cognitive_performance_index_B5_iron")
    model.addConstr(7 * vitamin_B12 + 13 * vitamin_B5 <= 67, name="cognitive_performance_index_B12_B5")
    model.addConstr(7 * vitamin_B12 + 13 * vitamin_B5 + 8 * iron <= 67, name="cognitive_performance_index_total")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Vitamin B12: {vitamin_B12.varValue}")
        print(f"Vitamin B5: {vitamin_B5.varValue}")
        print(f"Iron: {iron.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_vitamins()
