
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
protein_bars = m.addVar(vtype=GRB.INTEGER, name="protein_bars")
pickles = m.addVar(vtype=GRB.CONTINUOUS, name="pickles")
green_beans = m.addVar(vtype=GRB.INTEGER, name="green_beans")
bananas = m.addVar(vtype=GRB.CONTINUOUS, name="bananas")
potatoes = m.addVar(vtype=GRB.CONTINUOUS, name="potatoes")
kiwis = m.addVar(vtype=GRB.INTEGER, name="kiwis")

# Set objective function
m.setObjective(2*protein_bars**2 + 9*protein_bars*pickles + protein_bars*green_beans + protein_bars*bananas + 4*protein_bars*potatoes + 8*protein_bars*kiwis + 6*pickles**2 + 3*pickles*green_beans + 4*pickles*bananas + 2*pickles*potatoes + 3*pickles*kiwis + 7*green_beans**2 + 2*green_beans*bananas + 9*green_beans*potatoes + 7*green_beans*kiwis + 7*bananas**2 + bananas*potatoes + 2*bananas*kiwis + 2*potatoes**2 + 4*potatoes*kiwis + 9*kiwis**2 + 6*protein_bars + 5*pickles + 8*green_beans + 6*bananas + 4*potatoes + 9*kiwis, GRB.MINIMIZE)

# Add constraints
m.addConstr(4*protein_bars + 1*potatoes >= 79, "c0")
m.addConstr(4*protein_bars + 27*bananas >= 102, "c1")
m.addConstr(27*bananas + 20*kiwis >= 133, "c2")
m.addConstr(27*bananas**2 + 1*potatoes**2 >= 118, "c3")
m.addConstr(17*pickles + 27*bananas >= 101, "c4")
m.addConstr(17*pickles**2 + 3*green_beans**2 >= 124, "c5")
m.addConstr(4*protein_bars**2 + 17*pickles**2 >= 46, "c6")
m.addConstr(17*pickles**2 + 27*bananas**2 + 1*potatoes**2 >= 127, "c7")
m.addConstr(4*protein_bars + 3*green_beans + 20*kiwis >= 127, "c8")
m.addConstr(3*green_beans + 27*bananas + 20*kiwis >= 127, "c9")
m.addConstr(4*protein_bars**2 + 17*pickles**2 + 1*potatoes**2 >= 127, "c10")
m.addConstr(4*protein_bars + 27*bananas + 20*kiwis >= 127, "c11")
m.addConstr(17*pickles + 3*green_beans + 1*potatoes >= 127, "c12")
m.addConstr(4*protein_bars**2 + 27*bananas**2 + 1*potatoes**2 >= 127, "c13")
m.addConstr(3*green_beans**2 + 27*bananas**2 + 1*potatoes**2 >= 127, "c14")
m.addConstr(4*protein_bars**2 + 17*pickles**2 + 20*kiwis**2 >= 127, "c15")
m.addConstr(17*pickles + 3*green_beans + 20*kiwis >= 127, "c16")
m.addConstr(27*bananas**2 + 1*potatoes**2 + 20*kiwis**2 >= 127, "c17")
m.addConstr(17*pickles + 27*bananas + 20*kiwis >= 127, "c18")
m.addConstr(4*protein_bars**2 + 17*pickles**2 + 3*green_beans**2 >= 127, "c19")
m.addConstr(3*green_beans + 1*potatoes + 20*kiwis >= 127, "c20")
m.addConstr(4*protein_bars**2 + 17*pickles**2 + 27*bananas**2 >= 127, "c21")
m.addConstr(17*pickles + 27*bananas + 1*potatoes >= 86, "c22")
m.addConstr(4*protein_bars + 3*green_beans + 20*kiwis >= 86, "c23")
m.addConstr(3*green_beans**2 + 27*bananas**2 + 20*kiwis**2 >= 86, "c24")
m.addConstr(4*protein_bars + 17*pickles + 1*potatoes >= 86, "c25")
# ... (rest of the fiber and cost constraints)

m.addConstr(4*protein_bars + 17*pickles + 3*green_beans <= 240, "c_fiber_ub")
# ... (rest of the upper bound constraints)


m.addConstr(-10*protein_bars**2 + 1*potatoes**2 >= 0, "c_quadratic")

m.addConstr(14*protein_bars + 9*bananas >= 40, "cost_c0")
# ... (rest of the cost constraints)

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
