
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=0, ub=None, vtype=gurobi.GRB.INTEGER, name="protein_bars")
    x1 = model.addVar(lb=None, ub=None, vtype=gurobi.GRB.CONTINUOUS, name="pickles")
    x2 = model.addVar(lb=0, ub=None, vtype=gurobi.GRB.INTEGER, name="green_beans")
    x3 = model.addVar(lb=None, ub=None, vtype=gurobi.GRB.CONTINUOUS, name="bananas")
    x4 = model.addVar(lb=None, ub=None, vtype=gurobi.GRB.CONTINUOUS, name="potatoes")
    x5 = model.addVar(lb=0, ub=None, vtype=gurobi.GRB.INTEGER, name="kiwis")

    # Define objective function
    model.setObjective(2*x0**2 + 9*x0*x1 + x0*x2 + x0*x3 + 4*x0*x4 + 8*x0*x5 + 
                      6*x1**2 + 3*x1*x2 + 4*x1*x3 + 2*x1*x4 + 3*x1*x5 + 
                      7*x2**2 + 2*x2*x3 + 9*x2*x4 + 7*x2*x5 + 
                      7*x3**2 + x3*x4 + 2*x3*x5 + 2*x4**2 + 4*x4*x5 + 
                      9*x5**2 + 6*x0 + 5*x1 + 8*x2 + 6*x3 + 4*x4 + 9*x5, 
                      gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(4*x0 + 17*x1 + 3*x2 + 27*x3 + x4 + 20*x5 >= 79, name="fiber_constraint_1")
    model.addConstr(4*x0 + 27*x3 >= 102, name="fiber_constraint_2")
    model.addConstr(27*x3 + 20*x5 >= 133, name="fiber_constraint_3")
    model.addConstr(x3**2 + x4**2 >= 118, name="fiber_constraint_4")
    model.addConstr(x1 + x3 >= 101, name="fiber_constraint_5")
    model.addConstr(x1**2 + x2**2 >= 124, name="fiber_constraint_6")
    model.addConstr(x0**2 + x1**2 >= 46, name="fiber_constraint_7")
    model.addConstr(x1**2 + x3**2 + x4**2 >= 127, name="fiber_constraint_8")
    model.addConstr(x0 + x2 + x5 >= 127, name="fiber_constraint_9")
    model.addConstr(x2 + x3 + x5 >= 127, name="fiber_constraint_10")
    model.addConstr(14*x0 + 10*x1 + 32*x2 + 9*x3 + 8*x4 + 22*x5 <= 439, name="cost_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("protein bars: ", x0.varValue)
        print("pickles: ", x1.varValue)
        print("green beans: ", x2.varValue)
        print("bananas: ", x3.varValue)
        print("potatoes: ", x4.varValue)
        print("kiwis: ", x5.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
