
from gurobipy import Model, GRB

# Create a new model
model = Model("vitamin_magnesium_optimization")

# Create variables
vitamin_b2 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b2")
magnesium = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="magnesium")

# Set objective function
model.setObjective(9*vitamin_b2**2 + 4*vitamin_b2*magnesium + 7*magnesium**2 + 8*vitamin_b2, GRB.MINIMIZE)

# Add constraints
model.addConstr(3*vitamin_b2 + 2*magnesium >= 55, "immune_support_min")
model.addConstr(3*vitamin_b2 + 2*magnesium <= 142, "immune_support_max")
model.addConstr(8*vitamin_b2 + 1*magnesium >= 21, "digestive_support_min")
model.addConstr(-3*vitamin_b2 + 3*magnesium >= 0, "vitamin_magnesium_ratio")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print('Optimal objective value:', model.objVal)
    print('Vitamin B2:', vitamin_b2.x)
    print('Magnesium:', magnesium.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status:', model.status)

