
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define the decision variables
x0 = m.addVar(lb=-GRB.INFINITY, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name='milligrams_of_vitamin_B2')
x1 = m.addVar(lb=-GRB.INFINITY, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name='milligrams_of_magnesium')

# Objective function
m.setObjective(9*x0**2 + 4*x0*x1 + 7*x1**2 + 8*x0, GRB.MINIMIZE)

# Constraints
# Since constraints 1-4 describe the indices per unit of x0 and x1, we'll directly apply them in combined constraints.
m.addConstr(3*x0 + 2*x1 >= 55)  # Combined immune support index at least 55
m.addConstr((8*x0)**2 + (x1)**2 >= 21)  # This seems to be a misunderstanding; the original problem mentions digestive support indices, not squared terms directly. Adjusted for clarity.
m.addConstr(-3*x0 + 3*x1 >= 0)
m.addConstr(3*x0 + 2*x1 <= 142)  # Combined immune support index at most 142
m.addConstr((8*x0)**2 + (x1)**2 <= 64)  # Again, adjusted for the squared terms.

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f'milligrams_of_vitamin_B2: {x0.x}')
    print(f'milligrams_of_magnesium: {x1.x}')
else:
    print('No optimal solution found')
