
import gurobi

def optimize_vitamin_magnesium():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    vitamin_B2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="vitamin_B2")
    magnesium = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="magnesium")

    # Objective function
    model.setObjective(9 * vitamin_B2 ** 2 + 4 * vitamin_B2 * magnesium + 7 * magnesium ** 2 + 8 * vitamin_B2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(3 * vitamin_B2 <= 148, name="immune_support_vitamin_B2")
    model.addConstr(8 * vitamin_B2 <= 76, name="digestive_support_vitamin_B2")
    model.addConstr(2 * magnesium <= 148, name="immune_support_magnesium")
    model.addConstr(magnesium <= 76, name="digestive_support_magnesium")
    model.addConstr(3 * vitamin_B2 + 2 * magnesium >= 55, name="total_immune_support_min")
    model.addConstr(8 * vitamin_B2 + magnesium >= 21, name="total_digestive_support_min")
    model.addConstr(-3 * vitamin_B2 + 3 * magnesium >= 0, name="linear_constraint")
    model.addConstr(3 * vitamin_B2 + 2 * magnesium <= 142, name="total_immune_support_max")
    model.addConstr((8 * vitamin_B2) ** 2 + magnesium ** 2 <= 64, name="total_digestive_support_max")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B2: {vitamin_B2.varValue}")
        print(f"Milligrams of magnesium: {magnesium.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("No feasible solution exists.")
    else:
        print("Optimization failed.")

optimize_vitamin_magnesium()
