
from gurobipy import Model, GRB

# Create a new model
model = Model("Resource Allocation")

# Create variables
bill_hours = model.addVar(vtype=GRB.CONTINUOUS, name="Bill_Hours")
john_hours = model.addVar(vtype=GRB.CONTINUOUS, name="John_Hours")

# Set objective function
model.setObjective(4.03 * bill_hours + 7.68 * john_hours, GRB.MAXIMIZE)

# Add constraints
model.addConstr(6.44 * bill_hours + 5.84 * john_hours >= 5, "Organization_Score_Min")
model.addConstr(2.16 * bill_hours + 2.06 * john_hours >= 39, "Productivity_Rating_Min")
model.addConstr(4.71 * bill_hours + 2.29 * john_hours >= 7, "Computer_Competence_Min")
model.addConstr(4 * bill_hours - 7 * john_hours >= 0, "Custom_Constraint")

model.addConstr(6.44 * bill_hours + 5.84 * john_hours <= 13, "Organization_Score_Max")
model.addConstr(6.44 * bill_hours + 5.84 * john_hours <= 13, "Organization_Score_Max_Redundant") # Redundant constraint
model.addConstr(2.16 * bill_hours + 2.06 * john_hours <= 78, "Productivity_Rating_Max")
model.addConstr(2.16 * bill_hours + 2.06 * john_hours <= 78, "Productivity_Rating_Max_Redundant") # Redundant constraint
model.addConstr(4.71 * bill_hours + 2.29 * john_hours <= 15, "Computer_Competence_Max")
model.addConstr(4.71 * bill_hours + 2.29 * john_hours <= 15, "Computer_Competence_Max_Redundant") # Redundant constraint


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Bill's hours: {bill_hours.x}")
    print(f"John's hours: {john_hours.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

