
from gurobi import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables: hours worked by Bill and John
hours_worked_by_Bill = m.addVar(lb=0, name="hours_worked_by_Bill")
hours_worked_by_John = m.addVar(lb=0, name="hours_worked_by_John")

# Set the objective function
m.setObjective(4.03 * hours_worked_by_Bill + 7.68 * hours_worked_by_John, GRB.MAXIMIZE)

# Add constraints
# Organization score constraint: total combined ≥ 5 and ≤ 13
m.addConstr(6.44 * hours_worked_by_Bill + 5.84 * hours_worked_by_John >= 5, name="org_score_min")
m.addConstr(6.44 * hours_worked_by_Bill + 5.84 * hours_worked_by_John <= 13, name="org_score_max")

# Productivity rating constraint: total combined ≥ 39 and ≤ 78
m.addConstr(2.16 * hours_worked_by_Bill + 2.06 * hours_worked_by_John >= 39, name="prod_rating_min")
m.addConstr(2.16 * hours_worked_by_Bill + 2.06 * hours_worked_by_John <= 78, name="prod_rating_max")

# Computer competence rating constraint: total combined ≥ 7 and ≤ 15
m.addConstr(4.71 * hours_worked_by_Bill + 2.29 * hours_worked_by_John >= 7, name="comp_comp_min")
m.addConstr(4.71 * hours_worked_by_Bill + 2.29 * hours_worked_by_John <= 15, name="comp_comp_max")

# Specific linear constraint
m.addConstr(4 * hours_worked_by_Bill - 7 * hours_worked_by_John >= 0, name="linear_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Bill: {hours_worked_by_Bill.x}")
    print(f"Hours worked by John: {hours_worked_by_John.x}")
else:
    print("No optimal solution found")
