
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    hours_worked_by_bill = model.addVar(name="hours_worked_by_bill", lb=0)
    hours_worked_by_john = model.addVar(name="hours_worked_by_john", lb=0)

    # Objective function
    model.setObjective(4.03 * hours_worked_by_bill + 7.68 * hours_worked_by_john, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(6.44 * hours_worked_by_bill + 5.84 * hours_worked_by_john >= 5, name="org_score_min")
    model.addConstr(6.44 * hours_worked_by_bill + 5.84 * hours_worked_by_john <= 13, name="org_score_max")
    model.addConstr(2.16 * hours_worked_by_bill + 2.06 * hours_worked_by_john >= 39, name="productivity_min")
    model.addConstr(2.16 * hours_worked_by_bill + 2.06 * hours_worked_by_john <= 78, name="productivity_max")
    model.addConstr(4.71 * hours_worked_by_bill + 2.29 * hours_worked_by_john >= 7, name="computer_competence_min")
    model.addConstr(4.71 * hours_worked_by_bill + 2.29 * hours_worked_by_john <= 15, name="computer_competence_max")
    model.addConstr(4 * hours_worked_by_bill - 7 * hours_worked_by_john >= 0, name="linear_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Hours worked by Bill: {hours_worked_by_bill.varValue}")
        print(f"Hours worked by John: {hours_worked_by_john.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("The problem is infeasible")

solve_optimization_problem()
