
from gurobipy import Model, GRB

# Create a new model
m = Model("PlantOptimization")

# Create variables
chili_plants = m.addVar(vtype=GRB.INTEGER, name="chili_plants")
pansies = m.addVar(vtype=GRB.INTEGER, name="pansies")
roses = m.addVar(vtype=GRB.INTEGER, name="roses")

# Set objective function
m.setObjective(8 * chili_plants + 7 * pansies + 3 * roses, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * chili_plants + 2 * roses <= 13, "c1")
m.addConstr(4 * pansies + 2 * roses <= 11, "c2")
m.addConstr(5 * chili_plants + 4 * pansies + 2 * roses <= 26, "c3")
m.addConstr(5 * chili_plants + 1 * pansies <= 21, "c4")
m.addConstr(5 * chili_plants + 2 * roses <= 11, "c5")
m.addConstr(1 * pansies + 2 * roses <= 23, "c6")
m.addConstr(5 * chili_plants + 1 * pansies + 2 * roses <= 28, "c7")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('chili_plants:', chili_plants.x)
    print('pansies:', pansies.x)
    print('roses:', roses.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

