
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Create variables
x0 = m.addVar(vtype=GRB.INTEGER, name="chili_plants")
x1 = m.addVar(vtype=GRB.INTEGER, name="pansies")
x2 = m.addVar(vtype=GRB.INTEGER, name="roses")

# Set the objective function
m.setObjective(8*x0 + 7*x1 + 3*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x0 + 2*x2 <= 13, "growth_speed_1")
m.addConstr(4*x1 + 2*x2 <= 11, "growth_speed_2")
m.addConstr(5*x0 + 4*x1 + 2*x2 <= 26, "total_growth_speed")
m.addConstr(5*x0 + x1 <= 21, "cost_1")
m.addConstr(5*x0 + 2*x2 <= 11, "cost_2")
m.addConstr(x1 + 2*x2 <= 23, "cost_3")
m.addConstr(5*x0 + x1 + 2*x2 <= 28, "total_cost")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Chili plants: {x0.x}")
    print(f"Pansies: {x1.x}")
    print(f"Roses: {x2.x}")
    print(f"Objective value: {m.objVal}")
else:
    print("No optimal solution found.")
