
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    chili_plants = model.addVar(name="chili_plants", vtype=gurobi.GRB.INTEGER)
    pansies = model.addVar(name="pansies", vtype=gurobi.GRB.INTEGER)
    roses = model.addVar(name="roses", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(8 * chili_plants + 7 * pansies + 3 * roses, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5 * chili_plants + 2 * roses <= 13, name="growth_speed_chili_roses")
    model.addConstr(4 * pansies + 2 * roses <= 11, name="growth_speed_pansies_roses")
    model.addConstr(5 * chili_plants + 4 * pansies + 2 * roses <= 26, name="growth_speed_all")
    model.addConstr(5 * chili_plants + pansies <= 21, name="cost_chili_pansies")
    model.addConstr(5 * chili_plants + 2 * roses <= 11, name="cost_chili_roses")
    model.addConstr(pansies + 2 * roses <= 23, name="cost_pansies_roses")
    model.addConstr(5 * chili_plants + pansies + 2 * roses <= 28, name="cost_all")

    # Non-negativity constraints (implicit for integer variables)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Chili Plants: {chili_plants.varValue}")
        print(f"Pansies: {pansies.varValue}")
        print(f"Roses: {roses.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
