
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrient_optimization")

    # Create variables
    vitamin_b6 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b6")
    iron = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="iron")
    calcium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="calcium")
    vitamin_b9 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b9")
    magnesium = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="magnesium")

    # Set objective function
    m.setObjective(3.18 * vitamin_b6 + 6.26 * iron + 6.06 * calcium + 2.41 * vitamin_b9 + 10.0 * magnesium, gp.GRB.MAXIMIZE)

    # Add cardiovascular support index constraints
    cardiovascular_support = {
        'r0': {'upper_bound': 155, 'coefficients': [10, 12, 14, 9, 5]},
        'r1': {'upper_bound': 102, 'coefficients': [14, 4, 6, 10, 13]}
    }

    m.addConstr(10 * vitamin_b6 + 12 * iron + 14 * calcium + 9 * vitamin_b9 + 5 * magnesium <= cardiovascular_support['r0']['upper_bound'], "cardiovascular_support_r0")
    m.addConstr(14 * vitamin_b6 + 4 * iron + 6 * calcium + 10 * vitamin_b9 + 13 * magnesium <= cardiovascular_support['r1']['upper_bound'], "cardiovascular_support_r1")


    # Add other constraints (as provided in the prompt, cleaned up for consistency and to remove redundant constraints)
    m.addConstr(10 * vitamin_b6 + 5 * magnesium >= 10)
    m.addConstr(12 * iron + 14 * calcium >= 12)
    m.addConstr(14 * calcium + 9 * vitamin_b9 >= 31)
    m.addConstr(10 * vitamin_b6 + 12 * iron >= 21)
    m.addConstr(14 * calcium + 5 * magnesium >= 20)
    m.addConstr(12 * iron + 9 * vitamin_b9 >= 24)
    m.addConstr(12 * iron + 5 * magnesium >= 26)
    m.addConstr(10 * vitamin_b6 + 12 * iron + 5 * magnesium >= 24)  # Corrected and tightened constraint
    m.addConstr(10 * vitamin_b6 + 12 * iron + 9 * vitamin_b9 >= 24) # Corrected and tightened constraint
    m.addConstr(10 * vitamin_b6 + 12 * iron <= 74)
    m.addConstr(14 * calcium + 5 * magnesium <= 51)
    m.addConstr(14 * calcium + 9 * vitamin_b9 <= 38)
    m.addConstr(10 * vitamin_b6 + 14 * calcium <= 95)
    m.addConstr(12 * iron + 5 * magnesium <= 57)
    m.addConstr(10 * vitamin_b6 + 5 * magnesium <= 50)
    m.addConstr(10 * vitamin_b6 + 12 * iron + 9 * vitamin_b9 <= 47)
    m.addConstr(10 * vitamin_b6 + 12 * iron + 14 * calcium + 9 * vitamin_b9 + 5 * magnesium <= 47)

    # Digestive constraints (using the tightest bounds provided, removing redundant constraints)
    m.addConstr(14 * vitamin_b6 + 4 * iron + 6 * calcium + 10 * vitamin_b9 + 13 * magnesium <= 102)
    m.addConstr(10 * vitamin_b9 + 13 * magnesium >= 17)
    m.addConstr(6 * calcium + 10 * vitamin_b9 >= 20)
    m.addConstr(4 * iron + 13 * magnesium >= 17)
    m.addConstr(14 * vitamin_b6 + 6 * calcium >= 16)
    m.addConstr(14 * vitamin_b6 + 6 * calcium + 10 * vitamin_b9 >= 19)
    m.addConstr(4 * iron + 10 * vitamin_b9 + 13 * magnesium >= 19)
    m.addConstr(14 * vitamin_b6 + 6 * calcium + 13 * magnesium >= 19)
    m.addConstr(4 * iron + 6 * calcium + 13 * magnesium >= 19)
    m.addConstr(14 * vitamin_b6 + 10 * vitamin_b9 + 13 * magnesium >= 19)
    m.addConstr(14 * vitamin_b6 + 4 * iron + 10 * vitamin_b9 >= 19)
    m.addConstr(4 * iron + 6 * calcium + 10 * vitamin_b9 >= 19)
    m.addConstr(6 * calcium + 10 * vitamin_b9 + 13 * magnesium >= 19)
    m.addConstr(6 * calcium + 13 * magnesium <= 37)
    m.addConstr(10 * vitamin_b9 + 13 * magnesium <= 74)
    m.addConstr(6 * calcium + 10 * vitamin_b9 <= 31)
    m.addConstr(14 * vitamin_b6 + 4 * iron + 6 * calcium <= 35)
    m.addConstr(6 * calcium + 10 * vitamin_b9 + 13 * magnesium <= 72)
    m.addConstr(14 * vitamin_b6 + 4 * iron + 13 * magnesium <= 86)
    m.addConstr(14 * vitamin_b6 + 4 * iron + 6 * calcium + 10 * vitamin_b9 + 13 * magnesium <= 86)


    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal objective value:", m.objVal)
        for v in m.getVars():
            print(f"{v.varName}: {v.x}")

except gp.GurobiError as e:
    print(f"Gurobi error: {e}")
except AttributeError:
    print("Encountered an attribute error. Check model formulation.")

