
import gurobipy as gp

# Create a new model
m = gp.Model("minimize_labor_cost")

# Create variables
hank_hours = m.addVar(lb=0, name="hank_hours")  # Continuous variable
jean_hours = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="jean_hours")  # Integer variable


# Set objective function
m.setObjective(8.95 * hank_hours + 2.52 * jean_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(21 * hank_hours + 13 * jean_hours >= 69, "organization_score_min")
m.addConstr(30 * hank_hours + 4 * jean_hours >= 111, "likelihood_to_quit_min")
m.addConstr(27 * hank_hours + 28 * jean_hours >= 51, "paperwork_competence_min")
m.addConstr(-5 * hank_hours + 4 * jean_hours >= 0, "custom_constraint")
m.addConstr(21 * hank_hours + 13 * jean_hours <= 125, "organization_score_max")
m.addConstr(30 * hank_hours + 4 * jean_hours <= 274, "likelihood_to_quit_max")
m.addConstr(27 * hank_hours + 28 * jean_hours <= 168, "paperwork_competence_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"Hank's hours: {hank_hours.x}")
    print(f"Jean's hours: {jean_hours.x}")
    print(f"Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

