
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
hours_worked_by_Hank = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="hours_worked_by_Hank")
hours_worked_by_Jean = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="hours_worked_by_Jean")

# Objective function
m.setObjective(8.95 * hours_worked_by_Hank + 2.52 * hours_worked_by_Jean, GRB.MINIMIZE)

# Constraints
# Organization score constraints
m.addConstr(21 * hours_worked_by_Hank + 13 * hours_worked_by_Jean >= 69, name="org_score_min")
m.addConstr(21 * hours_worked_by_Hank + 13 * hours_worked_by_Jean <= 125, name="org_score_max")

# Likelihood to quit index constraints
m.addConstr(30 * hours_worked_by_Hank + 4 * hours_worked_by_Jean >= 111, name="quit_index_min")
m.addConstr(30 * hours_worked_by_Hank + 4 * hours_worked_by_Jean <= 274, name="quit_index_max")

# Paperwork competence rating constraints
m.addConstr(27 * hours_worked_by_Hank + 28 * hours_worked_by_Jean >= 51, name="paperwork_min")
m.addConstr(27 * hours_worked_by_Hank + 28 * hours_worked_by_Jean <= 168, name="paperwork_max")

# Additional linear constraint
m.addConstr(-5 * hours_worked_by_Hank + 4 * hours_worked_by_Jean >= 0, name="additional_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Hank: {hours_worked_by_Hank.x}")
    print(f"Hours worked by Jean: {hours_worked_by_Jean.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
