
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
hours_worked_by_Hank = m.addVar(name="hours_worked_by_Hank", lb=0)  # Assuming hours cannot be negative
hours_worked_by_Jean = m.addVar(name="hours_worked_by_Jean", lb=0, integrality=gp.GRB.INTEGER)  # Jean's hours must be an integer

# Objective function: Minimize 8.95*Hank + 2.52*Jean
m.setObjective(8.95 * hours_worked_by_Hank + 2.52 * hours_worked_by_Jean, gp.GRB.MINIMIZE)

# Constraints
# Individual scores (not actually constraints since they are given and not affecting the optimization directly)
# Organization scores
org_score_Hank = 21
org_score_Jean = 13

# Likelihood to quit indices
quit_index_Hank = 30
quit_index_Jean = 4

# Paperwork competence ratings
paperwork_Hank = 27
paperwork_Jean = 28

# Total combined organization score >= 69
m.addConstraint(org_score_Hank * hours_worked_by_Hank + org_score_Jean * hours_worked_by_Jean >= 69)

# Total combined likelihood to quit index >= 111
m.addConstraint(quit_index_Hank * hours_worked_by_Hank + quit_index_Jean * hours_worked_by_Jean >= 111)

# Total combined paperwork competence rating >= 51
m.addConstraint(paperwork_Hank * hours_worked_by_Hank + paperwork_Jean * hours_worked_by_Jean >= 51)

# Linear combination: -5*Hank + 4*Jean >= 0
m.addConstraint(-5 * hours_worked_by_Hank + 4 * hours_worked_by_Jean >= 0)

# Total combined organization score <= 125
m.addConstraint(org_score_Hank * hours_worked_by_Hank + org_score_Jean * hours_worked_by_Jean <= 125)

# Total combined likelihood to quit index <= 274
m.addConstraint(quit_index_Hank * hours_worked_by_Hank + quit_index_Jean * hours_worked_by_Jean <= 274)

# Total combined paperwork competence rating <= 168
m.addConstraint(paperwork_Hank * hours_worked_by_Hank + paperwork_Jean * hours_worked_by_Jean <= 168)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Hours worked by Hank: {hours_worked_by_Hank.varValue}")
    print(f"Hours worked by Jean: {hours_worked_by_Jean.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
