
import gurobipy as gp

# Create a new model
m = gp.Model("nutrient_optimization")

# Create variables
iron = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="iron")
zinc = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="zinc")
protein = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="protein")
vitamin_b9 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b9")
calcium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="calcium")
vitamin_e = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_e")

# Set objective function
m.setObjective(6.18 * iron + 5.22 * zinc + 9.39 * protein + 7.68 * vitamin_b9 + 3.2 * calcium + 5.76 * vitamin_e, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(12 * protein + 10 * vitamin_b9 >= 21, "c1")
m.addConstr(7 * zinc + 10 * vitamin_b9 >= 11, "c2")
m.addConstr(12 * protein + 3 * calcium >= 16, "c3")
m.addConstr(7 * zinc + 3 * calcium >= 20, "c4")
m.addConstr(7 * zinc + 2 * vitamin_e >= 22, "c5")
m.addConstr(12 * iron + 3 * calcium >= 27, "c6")
m.addConstr(12 * protein + 2 * vitamin_e >= 25, "c7")
m.addConstr(7 * zinc + 3 * calcium + 2 * vitamin_e >= 23, "c8")
m.addConstr(14 * zinc + 2 * protein >= 31, "c9")
m.addConstr(12 * iron + 6 * calcium >= 25, "c10")
m.addConstr(6 * calcium + 1 * vitamin_e >= 11, "c11")
m.addConstr(14 * zinc + 6 * calcium >= 15, "c12")
m.addConstr(2 * protein + 1 * vitamin_e >= 31, "c13")
m.addConstr(2 * protein + 9 * vitamin_b9 >= 32, "c14")
m.addConstr(12 * iron + 1 * vitamin_e >= 32, "c15")
m.addConstr(12 * iron + 9 * vitamin_b9 >= 16, "c16")
m.addConstr(12 * iron + 14 * zinc + 2 * protein >= 16, "c17")
m.addConstr(2 * protein + 9 * vitamin_b9 + 6 * calcium >= 16, "c18")
m.addConstr(12 * iron + 2 * protein + 1 * vitamin_e >= 16, "c19")
m.addConstr(14 * zinc + 6 * calcium + 1 * vitamin_e >= 16, "c20")

#Additional constraints from the prompt
m.addConstr(iron - 4 * calcium + 2 * vitamin_e >= 0, "c50")
m.addConstr(12 * iron + 7 * zinc <= 110, "c51")
m.addConstr(7 * zinc + 10 * vitamin_b9 <= 33, "c52")
m.addConstr(7 * zinc + 3 * calcium <= 55, "c53")
m.addConstr(12 * iron + 10 * vitamin_b9 <= 134, "c54")
m.addConstr(12 * iron + 7 * zinc + 12 * protein + 10 * vitamin_b9 + 3 * calcium + 2 * vitamin_e <= 134, "c55")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

