
from gurobipy import Model, GRB

# Create a new model
model = Model("Nutrition Optimization")

# Create variables
vitamin_a = model.addVar(vtype=GRB.CONTINUOUS, name="vitamin_a")
vitamin_b5 = model.addVar(vtype=GRB.INTEGER, name="vitamin_b5")
protein = model.addVar(vtype=GRB.CONTINUOUS, name="protein")
fat = model.addVar(vtype=GRB.CONTINUOUS, name="fat")

# Set objective function
model.setObjective(9.11 * vitamin_a + 2.55 * vitamin_b5 + 5.21 * protein + 9.45 * fat, GRB.MAXIMIZE)

# Add constraints
model.addConstr(8 * vitamin_a + 7 * vitamin_b5 + 15 * fat >= 31, "digestive_support_1")
model.addConstr(8 * vitamin_a + 7 * vitamin_b5 <= 89, "digestive_support_2")
model.addConstr(7 * vitamin_b5 + 2 * protein <= 111, "digestive_support_3")
model.addConstr(8 * vitamin_a + 15 * fat <= 95, "digestive_support_4")
model.addConstr(7 * vitamin_b5 + 15 * fat <= 94, "digestive_support_5")
model.addConstr(8 * vitamin_a + 7 * vitamin_b5 + 15 * fat <= 142, "digestive_support_6")
model.addConstr(8 * vitamin_a + 7 * vitamin_b5 + 2 * protein + 15 * fat <= 142, "digestive_support_7")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Vitamin A: %g' % vitamin_a.x)
    print('Vitamin B5: %g' % vitamin_b5.x)
    print('Protein: %g' % protein.x)
    print('Fat: %g' % fat.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

