
import gurobi

def optimize_nutrition():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    vitamin_A = model.addVar(lb=0, name="vitamin_A", vtype=gurobi.GRB.CONTINUOUS)  # mg
    vitamin_B5 = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="vitamin_B5")  # mg
    protein = model.addVar(lb=0, name="protein", vtype=gurobi.GRB.CONTINUOUS)  # g
    fat = model.addVar(lb=0, name="fat", vtype=gurobi.GRB.CONTINUOUS)  # g

    # Objective function
    model.setObjective(9.11 * vitamin_A + 2.55 * vitamin_B5 + 5.21 * protein + 9.45 * fat, gurobi.GRB.MAXIMIZE)

    # Constraints
    # DSI from mg of vitamin A, mg of vitamin B5, and g of fat must be 31 or more
    model.addConstraint(8 * vitamin_A + 7 * vitamin_B5 + 15 * fat >= 31)

    # DSI from mg of vitamin A and mg of vitamin B5 must be <= 89
    model.addConstraint(8 * vitamin_A + 7 * vitamin_B5 <= 89)

    # DSI from mg of vitamin B5 and g of protein must be <= 111
    model.addConstraint(7 * vitamin_B5 + 2 * protein <= 111)

    # DSI from mg of vitamin A and g of fat must be <= 95
    model.addConstraint(8 * vitamin_A + 15 * fat <= 95)

    # DSI from mg of vitamin B5 and g of fat must be <= 94
    model.addConstraint(7 * vitamin_B5 + 15 * fat <= 94)

    # DSI from mg of vitamin A, mg of vitamin B5, and g of fat must be <= 142
    model.addConstraint(8 * vitamin_A + 7 * vitamin_B5 + 15 * fat <= 142)

    # Total DSI from all variables must be <= 142
    model.addConstraint(8 * vitamin_A + 7 * vitamin_B5 + 2 * protein + 15 * fat <= 142)

    # Upper bound for digestive support index
    model.addConstraint(8 * vitamin_A + 7 * vitamin_B5 + 2 * protein + 15 * fat <= 171)

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Vitamin A: {vitamin_A.varValue} mg")
        print(f"Vitamin B5: {vitamin_B5.varValue} mg")
        print(f"Protein: {protein.varValue} g")
        print(f"Fat: {fat.varValue} g")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_nutrition()
