
import gurobi as gp

m = gp.Model("optimization_problem")

x0 = m.addVar(name="chicken_drumsticks", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="green_beans", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="knishes", vtype=gp.GRB.INTEGER)
x3 = m.addVar(name="fruit_salads", vtype=gp.GRB.INTEGER)
x4 = m.addVar(name="protein_bars", vtype=gp.GRB.INTEGER)
x5 = m.addVar(name="black_beans")

m.setObjective(2.46*x0**2 + 5.25*x0*x1 + 4.8*x0*x2 + 4.21*x0*x4 + 9.49*x1**2 + 5.39*x1*x3 + 6.9*x1*x4 + 5.57*x1*x5 + 1.22*x2**2 + 5.15*x2*x3 + 2.06*x3**2 + 5.06*x3*x5 + 7.42*x4**2 + 9.35*x4*x5 + 2.33*x0 + 9.27*x1 + 6.06*x2 + 5.93*x4 + 1.8*x5, gp.GRB.MINIMIZE)

# Sourness index constraints
m.addConstr(4*x0 + 11*x1 + 2*x2 + 9*x3 + 10*x4 + 10*x5 <= 191)
m.addConstr(2*x2 + 10*x5 >= 20)
m.addConstr(10*x4 + 10*x5 >= 20)
m.addConstr(11*x1 + 10*x5 >= 31)

# Fat constraints
m.addConstr(11*x0 + 4*x1 + 13*x2 + 2*x3 + 14*x4 + 13*x5 <= 105)

# Cost constraints
m.addConstr(13*x0 + 12*x1 + 11*x2 + 4*x3 + 1*x4 + 9*x5 <= 116)

# Calcium constraints
m.addConstr(11*x0 + 5*x1 + 8*x2 + 9*x3 + 6*x4 + 9*x5 <= 149)

# Bounds
m.addConstr(x0 >= 0)
m.addConstr(x1 >= 0)
m.addConstr(x2 >= 0)
m.addConstr(x3 >= 0)
m.addConstr(x4 >= 0)
m.addConstr(x5 >= 0)

m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Chicken drumsticks: ", x0.varValue)
    print("Green beans: ", x1.varValue)
    print("Knishes: ", x2.varValue)
    print("Fruit salads: ", x3.varValue)
    print("Protein bars: ", x4.varValue)
    print("Black beans: ", x5.varValue)
else:
    print("No optimal solution found")
