
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
fiber = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fiber")
vitamin_b3 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b3")
iron = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="iron")

# Set objective function
model.setObjective(4 * fiber + 5 * vitamin_b3 + 6 * iron, GRB.MINIMIZE)

# Add constraints
model.addConstr(3 * vitamin_b3 + 8 * iron >= 13, "c1")
model.addConstr(5 * fiber + 3 * vitamin_b3 >= 14, "c2")
model.addConstr(5 * fiber + 3 * vitamin_b3 + 8 * iron >= 14, "c3")
model.addConstr(-10 * fiber + 7 * iron >= 0, "c4")
model.addConstr(-7 * vitamin_b3 + 9 * iron >= 0, "c5")
model.addConstr(5 * fiber + 3 * vitamin_b3 <= 49, "c6")
model.addConstr(3 * vitamin_b3 + 8 * iron <= 51, "c7")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print('Optimal objective:', model.objVal)
    print('Fiber:', fiber.x)
    print('Vitamin B3:', vitamin_b3.x)
    print('Iron:', iron.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print(f"Optimization terminated with status {model.status}")

