
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the decision variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="grams_of_fiber")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B3")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_iron")

# Define the objective function
m.setObjective(4*x0 + 5*x1 + 6*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x1 + 8*x2 >= 13, "vitamin_B3_and_iron_index")
m.addConstr(5*x0 + 3*x1 >= 14, "fiber_and_vitamin_B3_index")
m.addConstr(5*x0 + 3*x1 + 8*x2 >= 14, "total_index")
m.addConstr(-10*x0 + 7*x2 >= 0, "fiber_and_iron_constraint")
m.addConstr(-7*x1 + 9*x2 >= 0, "vitamin_B3_and_iron_constraint")
m.addConstr(5*x0 + 3*x1 <= 49, "fiber_and_vitamin_B3_index_max")
m.addConstr(3*x1 + 8*x2 <= 51, "vitamin_B3_and_iron_index_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Grams of fiber: {x0.x}")
    print(f"Milligrams of vitamin B3: {x1.x}")
    print(f"Milligrams of iron: {x2.x}")
else:
    print("No optimal solution found")
