
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="grams_of_fiber", lb=0)  # No upper bound given
x1 = m.addVar(name="milligrams_of_vitamin_B3", lb=0)  # No upper bound given
x2 = m.addVar(name="milligrams_of_iron", lb=0)  # No upper bound given

# Objective function
m.setObjective(4*x0 + 5*x1 + 6*x2, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(5*x0 + 3*x1 + 8*x2 <= 55, name="energy_stability_index")
m.addConstr(3*x1 + 8*x2 >= 13, name="B3_iron_index")
m.addConstr(5*x0 + 3*x1 >= 14, name="fiber_B3_index")
m.addConstr(5*x0 + 3*x1 + 8*x2 >= 14, name="all_index")
m.addConstr(-10*x0 + 7*x2 >= 0, name="fiber_iron_relationship")
m.addConstr(-7*x1 + 9*x2 >= 0, name="B3_iron_relationship")
m.addConstr(5*x0 + 3*x1 <= 49, name="fiber_B3_upper_limit")
m.addConstr(3*x1 + 8*x2 <= 51, name="B3_iron_upper_limit")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Grams of fiber: {x0.varValue}")
    print(f"Milligrams of vitamin B3: {x1.varValue}")
    print(f"Milligrams of iron: {x2.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found")
