
from gurobipy import Model, GRB, quicksum

# Create a new model
model = Model("vitamin_optimization")

# Create variables
vitamin_a = model.addVar(vtype=GRB.INTEGER, name="vitamin_a")
vitamin_b5 = model.addVar(vtype=GRB.CONTINUOUS, name="vitamin_b5")

# Set objective function
model.setObjective(1.66 * vitamin_a**2 + 2.23 * vitamin_b5**2 + 5.28 * vitamin_b5, GRB.MINIMIZE)

# Add constraints
model.addConstr(20 * vitamin_a + 1 * vitamin_b5 >= 32, "immune_support_min")
model.addConstr(13 * vitamin_a + 5 * vitamin_b5 >= 11, "cardiovascular_support_min")
model.addConstr(5 * vitamin_a**2 - 4 * vitamin_b5**2 >= 0, "quadratic_constraint")
model.addConstr(20 * vitamin_a + 1 * vitamin_b5 <= 54, "immune_support_max")
model.addConstr(13 * vitamin_a + 5 * vitamin_b5 <= 43, "cardiovascular_support_max")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Milligrams of Vitamin A: {vitamin_a.x}")
    print(f"  Milligrams of Vitamin B5: {vitamin_b5.x}")
    print(f"  Objective Value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

